/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm.info;

import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.info.EdgeInfoPanelItemProvider;
import org.opennms.features.topology.api.info.item.DefaultInfoPanelItem;
import org.opennms.features.topology.api.info.item.InfoPanelItem;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.plugins.topo.bsm.AbstractBusinessServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceEdge;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServicesStatusProvider;
import org.opennms.features.topology.plugins.topo.bsm.info.BusinessServiceVertexStatusInfoPanelItemProvider;
import org.opennms.features.topology.plugins.topo.bsm.simulate.SimulationAwareStateMachineFactory;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.BusinessServiceStateMachine;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.vaadin.core.TransactionAwareBeanProxyFactory;

public class BusinessServiceEdgeStatusInfoPanelItemProvider
extends EdgeInfoPanelItemProvider {
    private BusinessServiceManager businessServiceManager;
    private final TransactionAwareBeanProxyFactory transactionAwareBeanProxyFactory;

    public BusinessServiceEdgeStatusInfoPanelItemProvider(TransactionAwareBeanProxyFactory transactionAwareBeanProxyFactory) {
        this.transactionAwareBeanProxyFactory = transactionAwareBeanProxyFactory;
    }

    public void setBusinessServiceManager(BusinessServiceManager businessServiceManager) {
        this.businessServiceManager = (BusinessServiceManager)this.transactionAwareBeanProxyFactory.createProxy((Object)businessServiceManager);
    }

    private Component createComponent(BusinessServiceEdge ref, GraphContainer container) {
        FormLayout formLayout = new FormLayout();
        formLayout.setMargin(false);
        formLayout.setSpacing(false);
        formLayout.addStyleName("severity");
        BusinessServiceStateMachine stateMachine = SimulationAwareStateMachineFactory.createStateMachine(this.businessServiceManager, container.getCriteria());
        Status outgoingStatus = BusinessServicesStatusProvider.getStatus(stateMachine, ref);
        Status incomingStatus = BusinessServicesStatusProvider.getStatus(stateMachine, (AbstractBusinessServiceVertex)ref.getTarget().getVertex());
        formLayout.addComponent((Component)BusinessServiceVertexStatusInfoPanelItemProvider.createStatusLabel("Outgoing Severity", outgoingStatus));
        formLayout.addComponent((Component)BusinessServiceVertexStatusInfoPanelItemProvider.createStatusLabel("Incoming Severity", incomingStatus));
        return formLayout;
    }

    protected boolean contributeTo(EdgeRef edgeRef, GraphContainer container) {
        return "bsm".equals(edgeRef.getNamespace());
    }

    protected InfoPanelItem createInfoPanelItem(EdgeRef ref, GraphContainer graphContainer) {
        return new DefaultInfoPanelItem().withOrder(0).withTitle("Map Function Status").withComponent(this.createComponent((BusinessServiceEdge)ref, graphContainer));
    }
}

