/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm.operations;

import java.util.List;
import java.util.Map;
import org.opennms.features.topology.api.AbstractCheckedOperation;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.bsm.simulate.InheritStateCriteria;
import org.opennms.features.topology.plugins.topo.bsm.simulate.SimulationAwareStateMachineFactory;

public class InheritStateOperation
extends AbstractCheckedOperation {
    private static final InheritStateCriteria crit = new InheritStateCriteria();

    protected boolean isChecked(GraphContainer container) {
        return container.findSingleCriteria(InheritStateCriteria.class) != null;
    }

    public void execute(List<VertexRef> targets, OperationContext operationContext) {
        GraphContainer container = operationContext.getGraphContainer();
        if (this.isChecked(operationContext.getGraphContainer())) {
            container.removeCriteria((Criteria)crit);
        } else {
            container.addCriteria((Criteria)crit);
        }
        container.redoLayout();
    }

    public boolean display(List<VertexRef> targets, OperationContext operationContext) {
        return true;
    }

    protected boolean enabled(GraphContainer container) {
        return SimulationAwareStateMachineFactory.isInSimulationMode(container.getCriteria());
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public void applyHistory(GraphContainer container, Map<String, String> settings) {
    }
}

