/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.topo.SearchQuery;
import org.opennms.features.topology.api.topo.SimpleSearchProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertex;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.model.BusinessService;

public class BusinessServiceSearchProvider
extends SimpleSearchProvider {
    private BusinessServiceManager businessServiceManager;

    public String getSearchProviderNamespace() {
        return "bsm";
    }

    public List<? extends VertexRef> queryVertices(SearchQuery searchQuery, GraphContainer container) {
        ArrayList results = Lists.newArrayList();
        String queryString = searchQuery.getQueryString();
        CriteriaBuilder bldr = new CriteriaBuilder(BusinessService.class);
        if (queryString != null && queryString.length() > 0) {
            bldr.ilike("name", (Object)String.format("%%%s%%", queryString));
        }
        bldr.orderBy("name", true);
        bldr.limit(Integer.valueOf(10));
        Criteria dbQueryCriteria = bldr.toCriteria();
        for (BusinessService bs : this.businessServiceManager.findMatching(dbQueryCriteria)) {
            BusinessServiceVertex businessServiceVertex = new BusinessServiceVertex(bs, 0);
            if (container.getTopologyServiceClient().getVertex((VertexRef)businessServiceVertex, new org.opennms.features.topology.api.topo.Criteria[0]) == null) continue;
            results.add(businessServiceVertex);
        }
        return results;
    }

    public void setBusinessServiceManager(BusinessServiceManager businessServiceManager) {
        this.businessServiceManager = Objects.requireNonNull(businessServiceManager);
    }
}

