/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.support.VertexHopGraphProvider;
import org.opennms.features.topology.api.topo.AbstractTopologyProvider;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Defaults;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.SimpleEdgeProvider;
import org.opennms.features.topology.api.topo.SimpleVertexProvider;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.bsm.AbstractBusinessServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceEdge;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertexProvider;
import org.opennms.features.topology.plugins.topo.bsm.GraphVertexToTopologyVertexConverter;
import org.opennms.features.topology.plugins.topo.bsm.IpServiceVertex;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.graph.BusinessServiceGraph;
import org.opennms.netmgt.bsm.service.model.graph.GraphEdge;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;
import org.opennms.netmgt.vaadin.core.TransactionAwareBeanProxyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessServicesTopologyProvider
extends AbstractTopologyProvider
implements GraphProvider {
    public static final String TOPOLOGY_NAMESPACE = "bsm";
    private static final Logger LOG = LoggerFactory.getLogger(BusinessServicesTopologyProvider.class);
    private BusinessServiceManager businessServiceManager;
    private final TransactionAwareBeanProxyFactory transactionAwareBeanProxyFactory;

    public BusinessServicesTopologyProvider(TransactionAwareBeanProxyFactory transactionAwareBeanProxyFactory) {
        super((SimpleVertexProvider)new BusinessServiceVertexProvider(TOPOLOGY_NAMESPACE), new SimpleEdgeProvider(TOPOLOGY_NAMESPACE));
        this.transactionAwareBeanProxyFactory = Objects.requireNonNull(transactionAwareBeanProxyFactory);
        LOG.debug("Creating a new {} with namespace {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)TOPOLOGY_NAMESPACE);
    }

    private void load() {
        this.resetContainer();
        BusinessServiceGraph graph = this.businessServiceManager.getGraph();
        for (GraphVertex topLevelBusinessService : graph.getVerticesByLevel(0)) {
            this.addVertex(graph, topLevelBusinessService, null);
        }
    }

    private void addVertex(BusinessServiceGraph graph, GraphVertex graphVertex, AbstractBusinessServiceVertex topologyVertex) {
        if (topologyVertex == null) {
            topologyVertex = this.createTopologyVertex(graphVertex);
            this.addVertices(new Vertex[]{topologyVertex});
        }
        for (GraphEdge graphEdge : graph.getOutEdges((Object)graphVertex)) {
            GraphVertex childVertex = (GraphVertex)graph.getOpposite((Object)graphVertex, (Object)graphEdge);
            AbstractBusinessServiceVertex childTopologyVertex = this.createTopologyVertex(childVertex);
            graph.getInEdges((Object)childVertex).stream().map(GraphEdge::getFriendlyName).filter(s -> !Strings.isNullOrEmpty((String)s)).findFirst().ifPresent(arg_0 -> ((AbstractBusinessServiceVertex)childTopologyVertex).setLabel(arg_0));
            this.addVertices(new Vertex[]{childTopologyVertex});
            childTopologyVertex.setParent((VertexRef)topologyVertex);
            BusinessServiceEdge edge = new BusinessServiceEdge(graphEdge, topologyVertex, childTopologyVertex);
            this.addEdges(new Edge[]{edge});
            this.addVertex(graph, childVertex, childTopologyVertex);
        }
    }

    private AbstractBusinessServiceVertex createTopologyVertex(GraphVertex graphVertex) {
        return GraphVertexToTopologyVertexConverter.createTopologyVertex(graphVertex);
    }

    public void setBusinessServiceManager(BusinessServiceManager businessServiceManager) {
        Objects.requireNonNull(businessServiceManager);
        this.businessServiceManager = (BusinessServiceManager)this.transactionAwareBeanProxyFactory.createProxy((Object)businessServiceManager);
    }

    public void refresh() {
        this.load();
    }

    public Defaults getDefaults() {
        return new Defaults().withPreferredLayout("Hierarchy Layout").withCriteria(() -> {
            List businessServices = this.businessServiceManager.findMatching(new CriteriaBuilder(BusinessService.class).orderBy("id", true).limit(Integer.valueOf(1)).toCriteria());
            if (!businessServices.isEmpty()) {
                BusinessService businessService = (BusinessService)businessServices.iterator().next();
                BusinessServiceVertex businessServiceVertex = new BusinessServiceVertex(businessService, 0);
                return Lists.newArrayList((Object[])new Criteria[]{new VertexHopGraphProvider.DefaultVertexHopCriteria((VertexRef)businessServiceVertex)});
            }
            return null;
        });
    }

    public void resetContainer() {
        super.resetContainer();
    }

    public SelectionChangedListener.Selection getSelection(List<VertexRef> selectedVertices, ContentType contentType) {
        Set filteredSet = selectedVertices.stream().filter(e -> TOPOLOGY_NAMESPACE.equals(e.getNamespace())).filter(e -> e instanceof AbstractBusinessServiceVertex).map(e -> (AbstractBusinessServiceVertex)((Object)e)).collect(Collectors.toSet());
        switch (contentType) {
            case Alarm: {
                Set reductionKeys = filteredSet.stream().map(AbstractBusinessServiceVertex::getReductionKeys).flatMap(Collection::stream).collect(Collectors.toSet());
                return () -> {
                    if (reductionKeys != null && !reductionKeys.isEmpty()) {
                        return Lists.newArrayList((Object[])new Restriction[]{Restrictions.in((String)"reductionKey", (Collection)reductionKeys)});
                    }
                    return Lists.newArrayList((Object[])new Restriction[]{Restrictions.isNull((String)"id")});
                };
            }
            case BusinessService: {
                HashSet businessServiceIds = Sets.newHashSet();
                filteredSet.stream().filter(v -> v.getType() == AbstractBusinessServiceVertex.Type.BusinessService).forEach(v -> businessServiceIds.add(((BusinessServiceVertex)((Object)v)).getServiceId()));
                filteredSet.stream().filter(v -> v.getType() == AbstractBusinessServiceVertex.Type.IpService).forEach(v -> businessServiceIds.add(((BusinessServiceVertex)v.getParent()).getServiceId()));
                filteredSet.stream().filter(v -> v.getType() == AbstractBusinessServiceVertex.Type.ReductionKey && ((AbstractBusinessServiceVertex)v.getParent()).getType() == AbstractBusinessServiceVertex.Type.BusinessService).forEach(v -> ((BusinessServiceVertex)v.getParent()).getServiceId());
                return new SelectionChangedListener.IdSelection((Collection)businessServiceIds);
            }
            case Node: {
                Set nodeIds = filteredSet.stream().filter(v -> v.getType() == AbstractBusinessServiceVertex.Type.IpService).map(v -> this.businessServiceManager.getIpServiceById(((IpServiceVertex)((Object)v)).getIpServiceId()).getNodeId()).collect(Collectors.toSet());
                return new SelectionChangedListener.IdSelection(nodeIds);
            }
        }
        throw new IllegalArgumentException(((Object)((Object)this)).getClass().getSimpleName() + " does not support filtering vertices for contentType " + contentType);
    }

    public boolean contributesTo(ContentType type) {
        return Sets.newHashSet((Object[])new ContentType[]{ContentType.Alarm, ContentType.Node, ContentType.BusinessService}).contains(type);
    }
}

