/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm.operations;

import java.util.Collection;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertexVisitor;
import org.opennms.features.topology.plugins.topo.bsm.IpServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.ReductionKeyVertex;
import org.opennms.features.topology.plugins.topo.bsm.operations.AbstractAnalysisOperation;
import org.opennms.netmgt.bsm.service.BusinessServiceStateMachine;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.IpService;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;

public class ImpactAnalysisOperation
extends AbstractAnalysisOperation {
    @Override
    public BusinessServiceVertexVisitor<Boolean> getVisitorForSupportedVertices() {
        return new BusinessServiceVertexVisitor<Boolean>(){

            @Override
            public Boolean visit(BusinessServiceVertex vertex) {
                return true;
            }

            @Override
            public Boolean visit(IpServiceVertex vertex) {
                return true;
            }

            @Override
            public Boolean visit(ReductionKeyVertex vertex) {
                return true;
            }
        };
    }

    @Override
    public BusinessServiceVertexVisitor<Collection<GraphVertex>> getVisitorForVerticesToFocus(final BusinessServiceStateMachine stateMachine) {
        return new BusinessServiceVertexVisitor<Collection<GraphVertex>>(){

            @Override
            public Collection<GraphVertex> visit(BusinessServiceVertex vertex) {
                BusinessService businessService = ImpactAnalysisOperation.this.getBusinessServiceManager().getBusinessServiceById(vertex.getServiceId());
                return stateMachine.calculateImpact(businessService);
            }

            @Override
            public Collection<GraphVertex> visit(IpServiceVertex vertex) {
                IpService ipService = ImpactAnalysisOperation.this.getBusinessServiceManager().getIpServiceById(vertex.getIpServiceId());
                return stateMachine.calculateImpact(ipService);
            }

            @Override
            public Collection<GraphVertex> visit(ReductionKeyVertex vertex) {
                return stateMachine.calculateImpact(vertex.getReductionKey());
            }
        };
    }

    @Override
    public String getMessageForNoResultDialog() {
        return "No vertices are impacted by the selected vertices.";
    }

    public String getId() {
        return this.getClass().getCanonicalName();
    }
}

