/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm.operations;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.Operation;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.support.VertexHopGraphProvider;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.bsm.AbstractBusinessServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertexVisitor;
import org.opennms.features.topology.plugins.topo.bsm.GraphVertexToTopologyVertexConverter;
import org.opennms.features.topology.plugins.topo.bsm.simulate.SimulationAwareStateMachineFactory;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.BusinessServiceStateMachine;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;
import org.opennms.netmgt.vaadin.core.InfoDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnalysisOperation
implements Operation {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAnalysisOperation.class);
    private BusinessServiceManager businessServiceManager;

    public abstract BusinessServiceVertexVisitor<Boolean> getVisitorForSupportedVertices();

    public abstract BusinessServiceVertexVisitor<Collection<GraphVertex>> getVisitorForVerticesToFocus(BusinessServiceStateMachine var1);

    public abstract String getMessageForNoResultDialog();

    public void execute(List<VertexRef> targets, OperationContext operationContext) {
        List<AbstractBusinessServiceVertex> vertices = this.getVertices(targets);
        BusinessServiceStateMachine stateMachine = SimulationAwareStateMachineFactory.createStateMachine(this.businessServiceManager, operationContext.getGraphContainer().getCriteria());
        HashSet graphVerticesToFocus = Sets.newHashSet();
        BusinessServiceVertexVisitor<Collection<GraphVertex>> visitor = this.getVisitorForVerticesToFocus(stateMachine);
        for (AbstractBusinessServiceVertex vertex : vertices) {
            graphVerticesToFocus.addAll(vertex.accept(visitor));
        }
        LOG.debug("Found {} business services.", (Object)graphVerticesToFocus.size());
        if (graphVerticesToFocus.isEmpty()) {
            new InfoDialog("No result", this.getMessageForNoResultDialog()).open();
        } else {
            this.focusOnVertices(targets.get(0), graphVerticesToFocus, operationContext.getGraphContainer());
        }
    }

    public List<AbstractBusinessServiceVertex> getVertices(List<VertexRef> targets) {
        if (targets == null) {
            return Collections.emptyList();
        }
        BusinessServiceVertexVisitor<Boolean> visitor = this.getVisitorForSupportedVertices();
        return targets.stream().filter(v -> v instanceof AbstractBusinessServiceVertex).map(v -> (AbstractBusinessServiceVertex)((Object)v)).filter(v -> (Boolean)v.accept(visitor)).collect(Collectors.toList());
    }

    private void focusOnVertices(VertexRef target, Set<GraphVertex> graphVerticesToFocus, GraphContainer container) {
        this.removeHopCriteria(container);
        graphVerticesToFocus.forEach(graphVertex -> container.addCriteria((Criteria)new VertexHopGraphProvider.DefaultVertexHopCriteria((VertexRef)GraphVertexToTopologyVertexConverter.createTopologyVertex(graphVertex))));
        container.addCriteria((Criteria)new VertexHopGraphProvider.DefaultVertexHopCriteria(target));
        container.setSemanticZoomLevel(0);
        container.getSelectionManager().setSelectedVertexRefs(Collections.emptyList());
        container.getSelectionManager().setSelectedEdgeRefs(Collections.emptyList());
        container.redoLayout();
    }

    private void removeHopCriteria(GraphContainer container) {
        Criteria[] currentCriteria = container.getCriteria();
        for (Criteria c : Arrays.copyOf(currentCriteria, currentCriteria.length)) {
            if (!(c instanceof VertexHopGraphProvider.DefaultVertexHopCriteria)) continue;
            container.removeCriteria(c);
        }
    }

    public boolean display(List<VertexRef> targets, OperationContext operationContext) {
        if (operationContext.getDisplayLocation() == OperationContext.DisplayLocation.MENUBAR) {
            return false;
        }
        return this.getVertices(targets).size() > 0;
    }

    public boolean enabled(List<VertexRef> targets, OperationContext operationContext) {
        return this.getVertices(targets).size() > 0;
    }

    public BusinessServiceManager getBusinessServiceManager() {
        return this.businessServiceManager;
    }

    public void setBusinessServiceManager(BusinessServiceManager businessServiceManager) {
        this.businessServiceManager = Objects.requireNonNull(businessServiceManager);
    }
}

