/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.application;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.support.hops.DefaultVertexHopCriteria;
import org.opennms.features.topology.api.topo.AbstractSearchProvider;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.SearchProvider;
import org.opennms.features.topology.api.topo.SearchQuery;
import org.opennms.features.topology.api.topo.SearchResult;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.application.LegacyApplicationVertex;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.opennms.netmgt.graph.api.search.GraphSearchService;
import org.opennms.netmgt.graph.api.search.SearchCriteria;
import org.opennms.netmgt.graph.provider.application.ApplicationVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyApplicationSearchProvider
extends AbstractSearchProvider
implements SearchProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyApplicationSearchProvider.class);
    private GraphSearchService graphSearchService;

    public String getSearchProviderNamespace() {
        return "application";
    }

    public boolean contributesTo(String namespace) {
        return "application".equalsIgnoreCase(namespace);
    }

    public boolean supportsPrefix(String searchPrefix) {
        return LegacyApplicationSearchProvider.supportsPrefix((String)"application=", (String)searchPrefix);
    }

    public List<SearchResult> query(SearchQuery searchQuery, GraphContainer container) {
        LOG.info("ApplicationServiceSearchProvider->query: called with search query: '{}'", (Object)searchQuery);
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.setNamespace("application");
        searchCriteria.setCriteria(searchQuery.getQueryString());
        List vertices = this.graphSearchService.search(searchCriteria);
        ArrayList results = Lists.newArrayList();
        for (GenericVertex genericVertex : vertices) {
            ApplicationVertex applicationVertex = new ApplicationVertex(genericVertex);
            LegacyApplicationVertex legacyApplicationVertex = new LegacyApplicationVertex(applicationVertex);
            SearchResult searchResult = new SearchResult((VertexRef)legacyApplicationVertex, true, false);
            results.add(searchResult);
        }
        LOG.info("ApplicationServiceSearchProvider->query: found {} results: {}", (Object)results.size(), (Object)results);
        return results;
    }

    public Set<VertexRef> getVertexRefsBy(SearchResult searchResult, GraphContainer container) {
        DefaultVertexRef vertexToFocus = new DefaultVertexRef(searchResult.getNamespace(), searchResult.getId(), searchResult.getLabel());
        return Sets.newHashSet((Object[])new VertexRef[]{vertexToFocus});
    }

    public void addVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        LOG.debug("ApplicationServiceSearchProvider->addVertexHopCriteria: called with search result: '{}'", (Object)searchResult);
        DefaultVertexHopCriteria criterion = new DefaultVertexHopCriteria((VertexRef)new DefaultVertexRef(searchResult.getNamespace(), searchResult.getId(), searchResult.getLabel()));
        container.addCriteria((Criteria)criterion);
        LOG.debug("ApplicationServiceSearchProvider->addVertexHop: adding hop criteria {}.", (Object)criterion);
        LOG.debug("ApplicationServiceSearchProvider->addVertexHop: current criteria {}.", (Object)Arrays.toString(container.getCriteria()));
    }

    public void removeVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        LOG.debug("ApplicationServiceSearchProvider->removeVertexHopCriteria: called with search result: '{}'", (Object)searchResult);
        DefaultVertexHopCriteria criterion = new DefaultVertexHopCriteria((VertexRef)new DefaultVertexRef(searchResult.getNamespace(), searchResult.getId(), searchResult.getLabel()));
        container.removeCriteria((Criteria)criterion);
        LOG.debug("ApplicationServiceSearchProvider->removeVertexHopCriteria: current criteria {}.", (Object)Arrays.toString(container.getCriteria()));
    }

    public void setGraphSearchService(GraphSearchService graphSearchService) {
        this.graphSearchService = graphSearchService;
    }
}

