/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.application;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.support.hops.DefaultVertexHopCriteria;
import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.AbstractRef;
import org.opennms.features.topology.api.topo.AbstractTopologyProvider;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.Defaults;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.application.LegacyApplicationVertex;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.service.GraphService;
import org.opennms.netmgt.graph.domain.AbstractDomainVertex;
import org.opennms.netmgt.graph.domain.simple.SimpleDomainEdge;
import org.opennms.netmgt.graph.provider.application.ApplicationGraph;
import org.opennms.netmgt.graph.provider.application.ApplicationVertex;
import org.opennms.netmgt.graph.provider.application.ApplicationVertexType;

public class LegacyApplicationTopologyProvider
extends AbstractTopologyProvider
implements GraphProvider {
    public static final String TOPOLOGY_NAMESPACE = "application";
    private GraphService graphService;

    public LegacyApplicationTopologyProvider(GraphService graphService) {
        super(TOPOLOGY_NAMESPACE);
        this.graphService = Objects.requireNonNull(graphService);
    }

    private void load() {
        this.graph.resetContainer();
        GenericGraph genericGraph = this.graphService.getGraph(TOPOLOGY_NAMESPACE);
        ApplicationGraph applicationGraph = new ApplicationGraph(genericGraph);
        for (ApplicationVertex eachApplicationVertex : applicationGraph.getVertices()) {
            LegacyApplicationVertex applicationVertex = new LegacyApplicationVertex(eachApplicationVertex);
            this.graph.addVertices(new Vertex[]{applicationVertex});
        }
        for (SimpleDomainEdge edge : applicationGraph.getEdges()) {
            DefaultVertexRef sourceRef = new DefaultVertexRef(edge.getSource().getNamespace(), edge.getSource().getId());
            DefaultVertexRef targetRef = new DefaultVertexRef(edge.getTarget().getNamespace(), edge.getTarget().getId());
            String id = String.format("connection:%s:%s", edge.getSource().getId(), edge.getTarget().getId());
            AbstractEdge convertedEdge = new AbstractEdge(edge.getNamespace(), id, (VertexRef)sourceRef, (VertexRef)targetRef);
            this.graph.addEdges(new Edge[]{convertedEdge});
        }
        for (ApplicationVertex serviceVertex : applicationGraph.getVertices()) {
            if (serviceVertex.getVertexType() != ApplicationVertexType.Service) continue;
            SimpleDomainEdge edge = (SimpleDomainEdge)applicationGraph.getConnectingEdges((AbstractDomainVertex)serviceVertex).stream().findFirst().orElseThrow(() -> new IllegalStateException("corrupt graph, each service should be connected to an application"));
            org.opennms.netmgt.graph.api.VertexRef parentRef = Stream.of(edge.getSource(), edge.getTarget()).filter(ref -> !ref.equals((Object)serviceVertex.getVertexRef())).findFirst().get();
            LegacyApplicationVertex parent = (LegacyApplicationVertex)this.graph.getVertex((VertexRef)new DefaultVertexRef(parentRef.getNamespace(), parentRef.getId()), new Criteria[0]);
            LegacyApplicationVertex child = (LegacyApplicationVertex)this.graph.getVertex((VertexRef)new DefaultVertexRef(serviceVertex.getNamespace(), serviceVertex.getId()), new Criteria[0]);
            if (parent == null) {
                throw new IllegalStateException("Parent vertex [namespace='" + parentRef.getNamespace() + "', id='" + parentRef.getId() + "'] was not found in graph.");
            }
            if (child == null) {
                throw new IllegalStateException("Child vertex [namespace='" + serviceVertex.getNamespace() + "', id='" + serviceVertex.getId() + "'] was not found in graph.");
            }
            parent.addChildren(child);
        }
    }

    public void refresh() {
        this.load();
    }

    public Defaults getDefaults() {
        return new Defaults().withPreferredLayout("Hierarchy Layout").withCriteria(() -> {
            GenericGraph genericGraph = this.graphService.getGraph(TOPOLOGY_NAMESPACE);
            ApplicationGraph applicationGraph = new ApplicationGraph(genericGraph.asGenericGraph());
            Optional<ApplicationVertex> firstVertex = applicationGraph.getVertices().stream().filter(v -> v.getVertexType() == ApplicationVertexType.Application).findFirst();
            if (firstVertex.isPresent()) {
                return Lists.newArrayList((Object[])new Criteria[]{new DefaultVertexHopCriteria((VertexRef)new LegacyApplicationVertex(firstVertex.get()))});
            }
            return null;
        });
    }

    public SelectionChangedListener.Selection getSelection(List<VertexRef> selectedVertices, ContentType contentType) {
        Set<LegacyApplicationVertex> filteredVertices = selectedVertices.stream().filter(v -> TOPOLOGY_NAMESPACE.equals(v.getNamespace())).map(v -> (LegacyApplicationVertex)((Object)v)).collect(Collectors.toSet());
        Set<Integer> nodeIds = this.extractNodeIds(filteredVertices);
        switch (contentType) {
            case Alarm: {
                return new SelectionChangedListener.AlarmNodeIdSelection(nodeIds);
            }
            case Node: {
                return new SelectionChangedListener.IdSelection(nodeIds);
            }
            case Application: {
                Set applicationIds = filteredVertices.stream().filter(LegacyApplicationVertex::isRoot).map(AbstractRef::getId).map(Integer::valueOf).collect(Collectors.toSet());
                return new SelectionChangedListener.IdSelection(applicationIds);
            }
        }
        throw new IllegalArgumentException(((Object)((Object)this)).getClass().getSimpleName() + " does not support filtering vertices for contentType " + contentType);
    }

    public boolean contributesTo(ContentType type) {
        return Sets.newHashSet((Object[])new ContentType[]{ContentType.Application, ContentType.Alarm, ContentType.Node}).contains(type);
    }

    private Set<Integer> extractNodeIds(Set<LegacyApplicationVertex> applicationVertices) {
        return applicationVertices.stream().filter(eachVertex -> TOPOLOGY_NAMESPACE.equals(eachVertex.getNamespace()) && eachVertex.getNodeID() != null).map(AbstractVertex::getNodeID).collect(Collectors.toSet());
    }
}

