/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.application;

import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultStatus;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.features.topology.api.topo.StatusProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.application.LegacyApplicationVertex;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.dao.api.MonitoredServiceStatusEntity;
import org.opennms.netmgt.model.OnmsSeverity;

public class LegacyApplicationStatusProvider
implements StatusProvider {
    private final ApplicationDao applicationDao;

    public LegacyApplicationStatusProvider(ApplicationDao applicationDao) {
        this.applicationDao = applicationDao;
    }

    public Map<VertexRef, Status> getStatusForVertices(BackendGraph graph, Collection<VertexRef> vertices, Criteria[] criteria) {
        HashMap<VertexRef, Status> returnMap = new HashMap<VertexRef, Status>();
        HashMap<Integer, DefaultStatus> statusMap = new HashMap<Integer, DefaultStatus>();
        List result = this.applicationDao.getAlarmStatus();
        for (MonitoredServiceStatusEntity eachRow : result) {
            DefaultStatus status = LegacyApplicationStatusProvider.createStatus(eachRow.getSeverity(), eachRow.getCount());
            statusMap.put(eachRow.getNodeId(), status);
        }
        List<VertexRef> vertexRefsForNamespace = this.getVertexRefsForNamespace(vertices);
        Collection<VertexRef> vertexRefsRoot = this.getRootElements(vertexRefsForNamespace);
        ArrayList<VertexRef> vertexRefs = new ArrayList<VertexRef>(vertexRefsForNamespace);
        vertexRefs.removeAll(vertexRefsRoot);
        for (VertexRef eachVertex : vertexRefs) {
            LegacyApplicationVertex applicationVertex = (LegacyApplicationVertex)eachVertex;
            Status alarmStatus = (Status)statusMap.get(applicationVertex.getNodeID());
            if (alarmStatus == null) {
                alarmStatus = LegacyApplicationStatusProvider.createStatus(OnmsSeverity.NORMAL, 0L);
            }
            returnMap.put(eachVertex, alarmStatus);
        }
        for (VertexRef eachRoot : vertexRefsRoot) {
            LegacyApplicationVertex eachRootApplication = (LegacyApplicationVertex)eachRoot;
            OnmsSeverity maxSeverity = OnmsSeverity.NORMAL;
            int count = 0;
            for (VertexRef eachChild : eachRootApplication.getChildren()) {
                LegacyApplicationVertex eachChildApplication = (LegacyApplicationVertex)eachChild;
                Integer childKey = eachChildApplication.getNodeID();
                Status childStatus = (Status)statusMap.get(childKey);
                if (childStatus == null || !maxSeverity.isLessThan(this.createSeverity(childStatus.computeStatus()))) continue;
                maxSeverity = this.createSeverity(childStatus.computeStatus());
                count = Integer.parseInt((String)childStatus.getStatusProperties().get("statusCount"));
            }
            returnMap.put(eachRoot, (Status)LegacyApplicationStatusProvider.createStatus(maxSeverity, count));
        }
        return returnMap;
    }

    private OnmsSeverity createSeverity(String label) {
        for (OnmsSeverity eachSeverity : OnmsSeverity.values()) {
            if (!label.equalsIgnoreCase(eachSeverity.name())) continue;
            return eachSeverity;
        }
        return null;
    }

    public String getNamespace() {
        return "application";
    }

    public boolean contributesTo(String namespace) {
        return this.getNamespace() != null && this.getNamespace().equals(namespace);
    }

    private Collection<VertexRef> getRootElements(Collection<VertexRef> vertices) {
        return Collections2.filter(vertices, input -> ((LegacyApplicationVertex)((Object)input)).isRoot());
    }

    private List<VertexRef> getVertexRefsForNamespace(Collection<VertexRef> vertices) {
        ArrayList<VertexRef> returnList = new ArrayList<VertexRef>();
        for (VertexRef eachRef : vertices) {
            if (!this.contributesTo(eachRef.getNamespace()) || returnList.contains(eachRef)) continue;
            returnList.add(eachRef);
        }
        return returnList;
    }

    private static DefaultStatus createStatus(OnmsSeverity severity, long count) {
        return new DefaultStatus(severity.getLabel(), count);
    }
}

