/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.application;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.support.VertexHopGraphProvider;
import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.AbstractTopologyProvider;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Defaults;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.SimpleEdgeProvider;
import org.opennms.features.topology.api.topo.SimpleVertexProvider;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.application.ApplicationVertex;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationTopologyProvider
extends AbstractTopologyProvider
implements GraphProvider {
    public static final String TOPOLOGY_NAMESPACE = "application";
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationTopologyProvider.class);
    private ApplicationDao applicationDao;

    public ApplicationTopologyProvider(ApplicationDao applicationDao) {
        super(new SimpleVertexProvider(TOPOLOGY_NAMESPACE), new SimpleEdgeProvider(TOPOLOGY_NAMESPACE));
        this.applicationDao = applicationDao;
        LOG.debug("Creating a new {} with namespace {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)TOPOLOGY_NAMESPACE);
    }

    private void load() {
        this.resetContainer();
        for (OnmsApplication application : this.applicationDao.findAll()) {
            ApplicationVertex applicationVertex = new ApplicationVertex(application);
            this.addVertices(new Vertex[]{applicationVertex});
            for (OnmsMonitoredService eachMonitoredService : application.getMonitoredServices()) {
                ApplicationVertex serviceVertex = new ApplicationVertex(eachMonitoredService);
                applicationVertex.addChildren(serviceVertex);
                this.addVertices(new Vertex[]{serviceVertex});
                String id = String.format("connection:%s:%s", applicationVertex.getId(), serviceVertex.getId());
                AbstractEdge edge = new AbstractEdge(this.getNamespace(), id, (VertexRef)applicationVertex, (VertexRef)serviceVertex);
                this.addEdges(new Edge[]{edge});
            }
        }
    }

    public void refresh() {
        this.load();
    }

    public Defaults getDefaults() {
        return new Defaults().withPreferredLayout("Hierarchy Layout").withCriteria(() -> {
            List applications = this.applicationDao.findAll();
            if (!applications.isEmpty()) {
                return Lists.newArrayList((Object[])new Criteria[]{new VertexHopGraphProvider.DefaultVertexHopCriteria((VertexRef)new ApplicationVertex((OnmsApplication)applications.get(0)))});
            }
            return null;
        });
    }

    public void resetContainer() {
        super.resetContainer();
    }

    public SelectionChangedListener.Selection getSelection(List<VertexRef> selectedVertices, ContentType contentType) {
        Set<ApplicationVertex> filteredVertices = selectedVertices.stream().filter(v -> TOPOLOGY_NAMESPACE.equals(v.getNamespace())).map(v -> (ApplicationVertex)((Object)v)).collect(Collectors.toSet());
        Set<Integer> nodeIds = this.extractNodeIds(filteredVertices);
        switch (contentType) {
            case Alarm: {
                return new SelectionChangedListener.AlarmNodeIdSelection(nodeIds);
            }
            case Node: {
                return new SelectionChangedListener.IdSelection(nodeIds);
            }
            case Application: {
                Set applicationIds = filteredVertices.stream().filter(v -> v.isRoot()).map(v -> Integer.valueOf(v.getId())).collect(Collectors.toSet());
                return new SelectionChangedListener.IdSelection(applicationIds);
            }
        }
        throw new IllegalArgumentException(((Object)((Object)this)).getClass().getSimpleName() + " does not support filtering vertices for contentType " + contentType);
    }

    public boolean contributesTo(ContentType type) {
        Object[] objectArray = new ContentType[3];
        objectArray[0] = ContentType.Application;
        objectArray[1] = ContentType.Alarm;
        objectArray[2] = ContentType.Node;
        return Sets.newHashSet((Object[])objectArray).contains(type);
    }

    private Set<Integer> extractNodeIds(Set<ApplicationVertex> applicationVertices) {
        return applicationVertices.stream().filter(eachVertex -> TOPOLOGY_NAMESPACE.equals(eachVertex.getNamespace()) && eachVertex.getNodeID() != null).map(eachVertex -> eachVertex.getNodeID()).collect(Collectors.toSet());
    }
}

