/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.application;

import java.util.ArrayList;
import java.util.List;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.LevelAware;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsServiceType;

public class ApplicationVertex
extends AbstractVertex
implements LevelAware {
    private List<VertexRef> children = new ArrayList<VertexRef>();
    private OnmsServiceType serviceType;

    public ApplicationVertex(OnmsApplication application) {
        this(application.getId().toString(), application.getName());
        this.setTooltipText(String.format("Application '%s'", application.getName()));
        this.setIconKey("application.application");
    }

    public ApplicationVertex(OnmsMonitoredService monitoredService) {
        this(monitoredService.getId().toString(), monitoredService.getServiceName());
        this.setIpAddress(monitoredService.getIpAddress().toString());
        this.setTooltipText(String.format("Service '%s', IP: %s", monitoredService.getServiceName(), monitoredService.getIpAddress().toString()));
        this.setNodeID(monitoredService.getNodeId());
        this.setServiceType(monitoredService.getServiceType());
        this.setIconKey("application.monitored-service");
    }

    public ApplicationVertex(String id, String label) {
        super("application", id, label);
    }

    public void addChildren(AbstractVertex vertex) {
        if (!this.children.contains(vertex)) {
            this.children.add((VertexRef)vertex);
            vertex.setParent((VertexRef)this);
        }
    }

    public void setServiceType(OnmsServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public List<VertexRef> getChildren() {
        return this.children;
    }

    public OnmsServiceType getServiceType() {
        return this.serviceType;
    }

    public boolean isPartOf(String applicationId) {
        return applicationId != null && applicationId.equals(this.getRoot().getId());
    }

    public ApplicationVertex getRoot() {
        if (this.isRoot()) {
            return this;
        }
        return ((ApplicationVertex)this.getParent()).getRoot();
    }

    public int getLevel() {
        return this.isRoot() ? 0 : 1;
    }
}

