/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.application;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultStatus;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.features.topology.api.topo.StatusProvider;
import org.opennms.features.topology.api.topo.VertexProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.application.ApplicationVertex;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.dao.api.ApplicationStatusEntity;
import org.opennms.netmgt.model.OnmsSeverity;

public class ApplicationStatusProvider
implements StatusProvider {
    private final ApplicationDao applicationDao;

    public ApplicationStatusProvider(ApplicationDao applicationDao) {
        this.applicationDao = applicationDao;
    }

    public Map<VertexRef, Status> getStatusForVertices(VertexProvider vertexProvider, Collection<VertexRef> vertices, Criteria[] criteria) {
        HashMap<VertexRef, Status> returnMap = new HashMap<VertexRef, Status>();
        HashMap<ApplicationStatusEntity.Key, DefaultStatus> statusMap = new HashMap<ApplicationStatusEntity.Key, DefaultStatus>();
        List result = this.applicationDao.getAlarmStatus();
        for (ApplicationStatusEntity eachRow : result) {
            DefaultStatus status = ApplicationStatusProvider.createStatus(eachRow.getSeverity(), eachRow.getCount());
            statusMap.put(eachRow.getKey(), status);
        }
        List<VertexRef> vertexRefsForNamespace = this.getVertexRefsForNamespace(vertices);
        Collection<VertexRef> vertexRefsRoot = this.getRootElements(vertexRefsForNamespace);
        ArrayList<VertexRef> vertexRefs = new ArrayList<VertexRef>(vertexRefsForNamespace);
        vertexRefs.removeAll(vertexRefsRoot);
        for (VertexRef eachVertex : vertexRefs) {
            ApplicationVertex applicationVertex = (ApplicationVertex)eachVertex;
            Status alarmStatus = (Status)statusMap.get(this.createKey(applicationVertex));
            if (alarmStatus == null) {
                alarmStatus = ApplicationStatusProvider.createStatus(OnmsSeverity.NORMAL, 0);
            }
            returnMap.put(eachVertex, alarmStatus);
        }
        for (VertexRef eachRoot : vertexRefsRoot) {
            ApplicationVertex eachRootApplication = (ApplicationVertex)eachRoot;
            OnmsSeverity maxSeverity = OnmsSeverity.NORMAL;
            int count = 0;
            for (VertexRef eachChild : eachRootApplication.getChildren()) {
                ApplicationVertex eachChildApplication = (ApplicationVertex)eachChild;
                ApplicationStatusEntity.Key childKey = this.createKey(eachChildApplication);
                Status childStatus = (Status)statusMap.get(childKey);
                if (childStatus == null || !maxSeverity.isLessThan(this.createSeverity(childStatus.computeStatus()))) continue;
                maxSeverity = this.createSeverity(childStatus.computeStatus());
                count = Integer.parseInt((String)childStatus.getStatusProperties().get("statusCount"));
            }
            returnMap.put(eachRoot, (Status)ApplicationStatusProvider.createStatus(maxSeverity, count));
        }
        return returnMap;
    }

    private OnmsSeverity createSeverity(String label) {
        for (OnmsSeverity eachSeverity : OnmsSeverity.values()) {
            if (!label.equalsIgnoreCase(eachSeverity.name())) continue;
            return eachSeverity;
        }
        return null;
    }

    private ApplicationStatusEntity.Key createKey(ApplicationVertex vertex) {
        return new ApplicationStatusEntity.Key(String.valueOf(vertex.getNodeID()), String.valueOf(vertex.getServiceType().getId()), vertex.getIpAddress());
    }

    public String getNamespace() {
        return "application";
    }

    public boolean contributesTo(String namespace) {
        return this.getNamespace() != null && this.getNamespace().equals(namespace);
    }

    private Collection<VertexRef> getRootElements(Collection<VertexRef> vertices) {
        return Collections2.filter(vertices, (Predicate)new Predicate<VertexRef>(){

            public boolean apply(VertexRef input) {
                return ((ApplicationVertex)input).isRoot();
            }
        });
    }

    private List<VertexRef> getVertexRefsForNamespace(Collection<VertexRef> vertices) {
        ArrayList<VertexRef> returnList = new ArrayList<VertexRef>();
        for (VertexRef eachRef : vertices) {
            if (!this.contributesTo(eachRef.getNamespace()) || returnList.contains(eachRef)) continue;
            returnList.add(eachRef);
        }
        return returnList;
    }

    private static DefaultStatus createStatus(OnmsSeverity severity, int count) {
        return new DefaultStatus(severity.getLabel(), (long)count);
    }
}

