/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.application.browsers;

import com.vaadin.data.Property;
import com.vaadin.ui.Button;
import com.vaadin.ui.Table;
import org.opennms.features.topology.api.browsers.AbstractSelectionLinkGenerator;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.browsers.ToStringColumnGenerator;
import org.opennms.features.topology.plugins.topo.application.ApplicationVertex;

public class ApplicationSelectionLinkGenerator
extends AbstractSelectionLinkGenerator {
    private final String labelPropertyName;
    private final String idPropertyName;
    private final Table.ColumnGenerator columnGenerator;

    public ApplicationSelectionLinkGenerator(String idPropertyName, String labelPropertyName) {
        this.idPropertyName = idPropertyName;
        this.labelPropertyName = labelPropertyName;
        this.columnGenerator = new ToStringColumnGenerator();
    }

    public Object generateCell(Table source, Object itemId, Object columnId) {
        final Property idProperty = source.getContainerProperty(itemId, (Object)this.idPropertyName);
        final Property labelProperty = source.getContainerProperty(itemId, (Object)this.labelPropertyName);
        Object cellValue = this.columnGenerator.generateCell(source, itemId, columnId);
        if (cellValue == null) {
            return null;
        }
        if (idProperty.getValue() == null) {
            return cellValue;
        }
        Button button = new Button(cellValue.toString());
        button.setStyleName("link");
        button.setDescription(((Integer)idProperty.getValue()).toString());
        button.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                Integer applicationId = (Integer)idProperty.getValue();
                String applicationName = (String)labelProperty.getValue();
                ApplicationVertex vertex = new ApplicationVertex(applicationId.toString(), applicationName);
                ApplicationSelectionLinkGenerator.this.fireVertexUpdatedEvent((VertexRef)vertex);
            }
        });
        return button;
    }
}

