/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.onmsdao.internal;

import java.util.ArrayList;
import java.util.List;
import org.opennms.features.topology.plugins.topo.onmsdao.internal.SimpleEdge;
import org.opennms.features.topology.plugins.topo.onmsdao.internal.SimpleGroup;

public abstract class SimpleVertex {
    String m_id;
    int m_x;
    int m_y;
    boolean m_selected;
    boolean m_locked = false;
    String m_icon;
    SimpleGroup m_parent = null;
    List<SimpleEdge> m_edges = new ArrayList<SimpleEdge>();
    private int m_semanticZoomLevel = -1;

    public SimpleVertex() {
    }

    public SimpleVertex(String id) {
        this.m_id = id;
    }

    public SimpleVertex(String id, int x, int y) {
        this.m_id = id;
        this.m_x = x;
        this.m_y = y;
    }

    public SimpleGroup getParent() {
        return this.m_parent;
    }

    public void setParent(SimpleGroup parent) {
        if (this.m_parent != null) {
            this.m_parent.removeMember(this);
        }
        this.m_parent = parent;
        if (this.m_parent != null) {
            this.m_parent.addMember(this);
        }
    }

    public boolean isLocked() {
        return this.m_locked;
    }

    public void setLocked(boolean locked) {
        this.m_locked = locked;
    }

    public abstract boolean isLeaf();

    public boolean isRoot() {
        return this.m_parent == null;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public int getX() {
        return this.m_x;
    }

    public void setX(int x) {
        this.m_x = x;
    }

    public int getY() {
        return this.m_y;
    }

    public void setY(int y) {
        this.m_y = y;
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public void setSelected(boolean selected) {
        this.m_selected = selected;
    }

    public String getIcon() {
        return this.m_icon;
    }

    public void setIcon(String icon) {
        this.m_icon = icon;
    }

    public List<SimpleEdge> getEdges() {
        return this.m_edges;
    }

    void addEdge(SimpleEdge edge) {
        this.m_edges.add(edge);
    }

    void removeEdge(SimpleEdge edge) {
        this.m_edges.remove(edge);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_id == null ? 0 : this.m_id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleVertex other = (SimpleVertex)obj;
        return !(this.m_id == null ? other.m_id != null : !this.m_id.equals(other.m_id));
    }

    public int getSemanticZoomLevel() {
        return this.m_semanticZoomLevel >= 0 ? this.m_semanticZoomLevel : (this.m_parent == null ? 0 : this.m_parent.getSemanticZoomLevel() + 1);
    }

    public SimpleVertex getDisplayVertex(int semanticZoomLevel) {
        if (this.getParent() == null || this.getSemanticZoomLevel() <= semanticZoomLevel) {
            return this;
        }
        return this.getParent().getDisplayVertex(semanticZoomLevel);
    }
}

