/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.EdgeListener;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.MetaInfo;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexListener;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeACLVertexProvider
implements GraphProvider {
    private static final Logger LOG = LoggerFactory.getLogger(NodeACLVertexProvider.class);
    private final GraphProvider m_delegate;
    private final NodeDao m_nodeDao;
    private final boolean m_aclsEnabled;

    public NodeACLVertexProvider(GraphProvider delegate, NodeDao nodeDao) {
        this.m_delegate = delegate;
        this.m_nodeDao = nodeDao;
        String aclsProp = System.getProperty("org.opennms.web.aclsEnabled");
        this.m_aclsEnabled = aclsProp != null ? aclsProp.equals("true") : false;
    }

    public void save() {
        this.m_delegate.save();
    }

    public void load(String filename) throws MalformedURLException, JAXBException {
        this.m_delegate.load(filename);
    }

    public void refresh() {
        this.m_delegate.refresh();
    }

    public void resetContainer() {
        this.m_delegate.resetContainer();
    }

    public void addVertices(Vertex ... vertices) {
        this.m_delegate.addVertices(vertices);
    }

    public void removeVertex(VertexRef ... vertexId) {
        this.m_delegate.removeVertex(vertexId);
    }

    public Vertex addVertex(int x, int y) {
        return this.m_delegate.addVertex(x, y);
    }

    public boolean groupingSupported() {
        return false;
    }

    public Vertex addGroup(String label, String iconKey) {
        return this.m_delegate.addGroup(label, iconKey);
    }

    public EdgeRef[] getEdgeIdsForVertex(VertexRef vertex) {
        return this.m_delegate.getEdgeIdsForVertex(vertex);
    }

    public Map<VertexRef, Set<EdgeRef>> getEdgeIdsForVertices(VertexRef ... vertex) {
        return this.m_delegate.getEdgeIdsForVertices(vertex);
    }

    public void addEdges(Edge ... edges) {
        this.m_delegate.addEdges(edges);
    }

    public void removeEdges(EdgeRef ... edges) {
        this.m_delegate.removeEdges(edges);
    }

    public Edge connectVertices(VertexRef sourceVertextId, VertexRef targetVertextId) {
        return this.m_delegate.connectVertices(sourceVertextId, targetVertextId);
    }

    public Criteria getDefaultCriteria() {
        return this.m_delegate.getDefaultCriteria();
    }

    public String getEdgeNamespace() {
        return this.m_delegate.getEdgeNamespace();
    }

    public Edge getEdge(String namespace, String id) {
        return this.m_delegate.getEdge(namespace, id);
    }

    public Edge getEdge(EdgeRef reference) {
        return this.m_delegate.getEdge(reference);
    }

    public List<Edge> getEdges(Criteria ... criteria) {
        return this.m_delegate.getEdges(criteria);
    }

    public List<Edge> getEdges(Collection<? extends EdgeRef> references) {
        return this.m_delegate.getEdges(references);
    }

    public void addEdgeListener(EdgeListener listener) {
        this.m_delegate.addEdgeListener(listener);
    }

    public void removeEdgeListener(EdgeListener listener) {
        this.m_delegate.removeEdgeListener(listener);
    }

    public void clearEdges() {
        this.m_delegate.clearEdges();
    }

    public String getVertexNamespace() {
        return this.m_delegate.getVertexNamespace();
    }

    public boolean contributesTo(String namespace) {
        return this.m_delegate.contributesTo(namespace);
    }

    public boolean containsVertexId(String id) {
        return this.m_delegate.containsVertexId(id);
    }

    public boolean containsVertexId(VertexRef id, Criteria ... criteria) {
        return this.m_delegate.containsVertexId(id, criteria);
    }

    public Vertex getVertex(String namespace, String id) {
        return this.m_delegate.getVertex(namespace, id);
    }

    public Vertex getVertex(VertexRef reference, Criteria ... criteria) {
        return this.m_delegate.getVertex(reference, criteria);
    }

    public int getSemanticZoomLevel(VertexRef vertex) {
        return this.m_delegate.getSemanticZoomLevel(vertex);
    }

    public List<Vertex> getVertices(Criteria ... criteria) {
        return this.filterVertices(this.m_delegate.getVertices(criteria));
    }

    private List<Vertex> filterVertices(List<Vertex> vertices) {
        if (this.m_aclsEnabled) {
            List onmsNodes = this.m_nodeDao.findAll();
            final HashSet nodes = new HashSet(Lists.transform((List)onmsNodes, (Function)new Function<OnmsNode, Integer>(){

                public Integer apply(OnmsNode node) {
                    return node.getId();
                }
            }));
            return Lists.newArrayList((Iterable)Collections2.filter(vertices, (Predicate)new Predicate<Vertex>(){

                public boolean apply(Vertex vertex) {
                    return vertex.getNamespace().toLowerCase().equals("nodes") ? nodes.contains(vertex.getNodeID()) : true;
                }
            }));
        }
        return vertices;
    }

    public List<Vertex> getVertices(Collection<? extends VertexRef> references, Criteria ... criteria) {
        return this.filterVertices(this.m_delegate.getVertices(references, criteria));
    }

    public List<Vertex> getRootGroup() {
        return this.m_delegate.getRootGroup();
    }

    public boolean hasChildren(VertexRef group) {
        return this.m_delegate.hasChildren(group);
    }

    public Vertex getParent(VertexRef vertex) {
        return this.m_delegate.getParent(vertex);
    }

    public boolean setParent(VertexRef child, VertexRef parent) {
        return this.m_delegate.setParent(child, parent);
    }

    public List<Vertex> getChildren(VertexRef group, Criteria ... criteria) {
        return this.filterVertices(this.m_delegate.getChildren(group, criteria));
    }

    public void addVertexListener(VertexListener vertexListener) {
        this.m_delegate.addVertexListener(vertexListener);
    }

    public void removeVertexListener(VertexListener vertexListener) {
        this.m_delegate.removeVertexListener(vertexListener);
    }

    public void clearVertices() {
        this.m_delegate.clearVertices();
    }

    public int getVertexTotalCount() {
        return this.m_delegate.getVertexTotalCount();
    }

    public SelectionChangedListener.Selection getSelection(List<VertexRef> selectedVertices, ContentType type) {
        return this.m_delegate.getSelection(selectedVertices, type);
    }

    public boolean contributesTo(ContentType type) {
        return this.m_delegate.contributesTo(type);
    }

    public MetaInfo getMetaInfo() {
        return this.m_delegate.getMetaInfo();
    }
}

