/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.EdgeProvider;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.EdgeStatusProvider;
import org.opennms.features.topology.api.topo.Status;
import org.osgi.framework.ServiceReference;

public class LinkdWrappedEdgeStatusProviders
implements EdgeStatusProvider {
    private EdgeStatusProvider m_llpdStatusProvider;
    private EdgeStatusProvider m_ospfLinkStatusProvider;
    private EdgeStatusProvider m_isisLinkStatusProvider;
    private EdgeStatusProvider m_bridgeLinkStatusProvider;
    private EdgeStatusProvider m_cdpLinkStatusProvider;
    private List<EdgeStatusProvider> m_providers;
    private Boolean m_enlinkdIsActive = false;

    public void init() {
        this.m_providers = new ArrayList<EdgeStatusProvider>();
        this.m_providers.add(this.m_llpdStatusProvider);
        this.m_providers.add(this.m_ospfLinkStatusProvider);
        this.m_providers.add(this.m_isisLinkStatusProvider);
        this.m_providers.add(this.m_bridgeLinkStatusProvider);
        this.m_providers.add(this.m_cdpLinkStatusProvider);
    }

    public Map<EdgeRef, Status> getStatusForEdges(EdgeProvider edgeProvider, Collection<EdgeRef> edges, Criteria[] criteria) {
        HashMap<EdgeRef, Status> edgeRefStatusMap = new HashMap<EdgeRef, Status>();
        for (EdgeStatusProvider statusProvider : this.m_providers) {
            edgeRefStatusMap.putAll(statusProvider.getStatusForEdges(edgeProvider, edges, criteria));
        }
        return edgeRefStatusMap;
    }

    public String getNamespace() {
        return "nodes";
    }

    public boolean contributesTo(String namespace) {
        return namespace != null && namespace.equals(this.getNamespace());
    }

    public void setEnlinkdService(ServiceReference<?> enlinkdService) {
        if (enlinkdService != null) {
            this.m_enlinkdIsActive = true;
        }
    }

    public void setLlpdStatusProvider(EdgeStatusProvider llpdStatusProvider) {
        this.m_llpdStatusProvider = llpdStatusProvider;
    }

    public void setOspfLinkStatusProvider(EdgeStatusProvider ospfLinkStatusProvider) {
        this.m_ospfLinkStatusProvider = ospfLinkStatusProvider;
    }

    public void setIsisLinkStatusProvider(EdgeStatusProvider isisLinkStatusProvider) {
        this.m_isisLinkStatusProvider = isisLinkStatusProvider;
    }

    public void setBridgeLinkStatusProvider(EdgeStatusProvider bridgeLinkStatusProvider) {
        this.m_bridgeLinkStatusProvider = bridgeLinkStatusProvider;
    }

    public EdgeStatusProvider getCdpLinkStatusProvider() {
        return this.m_cdpLinkStatusProvider;
    }

    public void setCdpLinkStatusProvider(EdgeStatusProvider cdpLinkStatusProvider) {
        this.m_cdpLinkStatusProvider = cdpLinkStatusProvider;
    }
}

