/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.InRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.plugins.topo.linkd.internal.AbstractLinkStatusProvider;
import org.opennms.netmgt.dao.api.IsIsLinkDao;
import org.opennms.netmgt.model.IsIsElement;
import org.opennms.netmgt.model.IsIsLink;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.topology.EdgeAlarmStatusSummary;

public class IsIsLinkStatusProvider
extends AbstractLinkStatusProvider {
    private IsIsLinkDao m_isIsLinkDao;

    @Override
    public String getNamespace() {
        return "nodes::ISIS";
    }

    @Override
    protected List<EdgeAlarmStatusSummary> getEdgeAlarmSummaries(List<Integer> linkIds) {
        Criteria criteria = new Criteria(IsIsLink.class);
        criteria.addRestriction((Restriction)new InRestriction("id", linkIds));
        List links = this.getIsisLinkDao().findMatching(criteria);
        HashMultimap summaryMap = HashMultimap.create();
        for (IsIsLink sourceLink : links) {
            OnmsNode sourceNode = sourceLink.getNode();
            IsIsElement sourceElement = sourceNode.getIsisElement();
            for (IsIsLink targetLink : links) {
                boolean isisAdjIndexCheck = sourceLink.getIsisISAdjIndex() == targetLink.getIsisISAdjIndex();
                boolean isisSysIdCheck = targetLink.getIsisISAdjNeighSysID().equals(sourceElement.getIsisSysID());
                if (!isisAdjIndexCheck || !isisSysIdCheck) continue;
                summaryMap.put((Object)(sourceNode.getNodeId() + ":" + sourceLink.getIsisCircIfIndex()), (Object)new EdgeAlarmStatusSummary(sourceLink.getId().intValue(), targetLink.getId().intValue(), null));
            }
        }
        List<OnmsAlarm> alarms = this.getLinkDownAlarms();
        for (OnmsAlarm alarm : alarms) {
            String key = alarm.getNodeId() + ":" + alarm.getIfIndex();
            if (!summaryMap.containsKey((Object)key)) continue;
            Collection summaries = summaryMap.get((Object)key);
            for (EdgeAlarmStatusSummary summary : summaries) {
                summary.setEventUEI(alarm.getUei());
            }
        }
        return new ArrayList<EdgeAlarmStatusSummary>(summaryMap.values());
    }

    @Override
    protected Set<Integer> getLinkIds(Map<String, EdgeRef> mappedRefs) {
        HashSet<Integer> linkIds = new HashSet<Integer>();
        for (String edgeRefId : mappedRefs.keySet()) {
            if (!edgeRefId.contains("|")) continue;
            int charIndex = edgeRefId.indexOf(124);
            int sourceId = Integer.parseInt(edgeRefId.substring(0, charIndex));
            int targetId = Integer.parseInt(edgeRefId.substring(charIndex + 1, edgeRefId.length()));
            linkIds.add(sourceId);
            linkIds.add(targetId);
        }
        return linkIds;
    }

    public IsIsLinkDao getIsisLinkDao() {
        return this.m_isIsLinkDao;
    }

    public void setIsisLinkDao(IsIsLinkDao isIsLinkDao) {
        this.m_isIsLinkDao = isIsLinkDao;
    }
}

