/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultStatus;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.features.topology.api.topo.StatusProvider;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.alarm.AlarmSummary;
import org.slf4j.LoggerFactory;

public class AlarmStatusProvider
implements StatusProvider {
    private final AlarmDao m_alarmDao;

    public String getNamespace() {
        return "nodes";
    }

    public boolean contributesTo(String namespace) {
        return this.getNamespace() != null && this.getNamespace().equals(namespace);
    }

    public AlarmStatusProvider(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public Map<VertexRef, Status> getStatusForVertices(VertexProvider vertexProvider, Collection<VertexRef> vertices, Criteria[] criteria) {
        HashMap<VertexRef, Status> returnMap = new HashMap<VertexRef, Status>();
        List<VertexRef> nodeRefs = AlarmStatusProvider.getNodeVertexRefs(vertexProvider, vertices, criteria);
        List<VertexRef> otherRefs = AlarmStatusProvider.getOtherVertexRefs(vertices);
        Map<Integer, VertexRef> nodeIdMap = AlarmStatusProvider.extractNodeIds(nodeRefs);
        Map<Integer, AlarmSummary> nodeIdToAlarmSummaryMap = this.getAlarmSummaries(nodeIdMap.keySet());
        for (Integer eachNodeId : nodeIdMap.keySet()) {
            AlarmSummary summary = nodeIdToAlarmSummaryMap.get(eachNodeId);
            AlarmStatus status = summary == null ? AlarmStatusProvider.createIndeterminateStatus() : AlarmStatusProvider.createStatus(summary);
            VertexRef ref = nodeIdMap.get(eachNodeId);
            returnMap.put(ref, (Status)status);
            LoggerFactory.getLogger(this.getClass()).debug("Status for node '{}' with id '{}' is: {}", new Object[]{ref.getLabel(), ref.getId(), status});
        }
        for (VertexRef eachRef : otherRefs) {
            if (AlarmStatusProvider.isGroup(eachRef)) {
                ArrayList<AlarmSummary> alarmSummariesForGroup = new ArrayList<AlarmSummary>();
                List children = vertexProvider.getChildren(eachRef, criteria);
                for (Vertex eachChildren : children) {
                    AlarmSummary eachChildrenAlarmSummary = nodeIdToAlarmSummaryMap.get(eachChildren.getNodeID());
                    if (eachChildrenAlarmSummary == null) continue;
                    alarmSummariesForGroup.add(eachChildrenAlarmSummary);
                }
                AlarmStatus groupStatus = AlarmStatusProvider.calculateAlarmStatusForGroup(alarmSummariesForGroup);
                returnMap.put(eachRef, (Status)groupStatus);
                continue;
            }
            returnMap.put(eachRef, (Status)AlarmStatusProvider.createIndeterminateStatus());
        }
        return returnMap;
    }

    private Map<Integer, AlarmSummary> getAlarmSummaries(Set<Integer> nodeIds) {
        HashMap<Integer, AlarmSummary> resultMap = new HashMap<Integer, AlarmSummary>();
        List alarmSummaries = this.m_alarmDao.getNodeAlarmSummariesIncludeAcknowledgedOnes(new ArrayList<Integer>(nodeIds));
        for (AlarmSummary eachSummary : alarmSummaries) {
            resultMap.put(eachSummary.getNodeId(), eachSummary);
        }
        return resultMap;
    }

    private static AlarmStatus createStatus(AlarmSummary summary) {
        return new AlarmStatus(summary.getMaxSeverity().getLabel(), summary.getAlarmCount());
    }

    private static Map<Integer, VertexRef> extractNodeIds(Collection<VertexRef> inputList) {
        HashMap<Integer, VertexRef> vertexRefToNodeIdMap = new HashMap<Integer, VertexRef>();
        for (VertexRef eachRef : inputList) {
            if (!"nodes".equals(eachRef.getNamespace())) continue;
            try {
                Integer nodeId = Integer.parseInt(eachRef.getId());
                if (nodeId == null) continue;
                vertexRefToNodeIdMap.put(nodeId, eachRef);
            }
            catch (NumberFormatException nfe) {
                LoggerFactory.getLogger(AlarmStatusProvider.class).warn("Could not parse id '{}' of vertex '{}' as integer.", (Object)eachRef.getId(), (Object)eachRef);
            }
        }
        return vertexRefToNodeIdMap;
    }

    private static List<VertexRef> getNodeVertexRefs(VertexProvider vertexProvider, Collection<VertexRef> vertices, Criteria[] criteria) {
        ArrayList<VertexRef> returnList = new ArrayList<VertexRef>();
        for (VertexRef eachRef : vertices) {
            if (!"nodes".equals(eachRef.getNamespace())) continue;
            if (AlarmStatusProvider.isGroup(eachRef)) {
                AlarmStatusProvider.addChildrenRecursively(vertexProvider, eachRef, returnList, criteria);
                continue;
            }
            if (returnList.contains(eachRef)) continue;
            returnList.add(eachRef);
        }
        return returnList;
    }

    private static List<VertexRef> getOtherVertexRefs(Collection<VertexRef> vertices) {
        ArrayList<VertexRef> returnList = new ArrayList<VertexRef>();
        for (VertexRef eachRef : vertices) {
            if ("nodes".equals(eachRef.getNamespace())) continue;
            returnList.add(eachRef);
        }
        return returnList;
    }

    private static void addChildrenRecursively(VertexProvider vertexProvider, VertexRef groupRef, Collection<VertexRef> vertexRefs, Criteria[] criteria) {
        List vertices = vertexProvider.getChildren(groupRef, criteria);
        for (Vertex vertex : vertices) {
            if (!vertex.isGroup()) {
                if (vertexRefs.contains(vertex)) continue;
                vertexRefs.add((VertexRef)vertex);
                continue;
            }
            AlarmStatusProvider.addChildrenRecursively(vertexProvider, (VertexRef)vertex, vertexRefs, criteria);
        }
    }

    private static boolean isGroup(VertexRef vertexRef) {
        if (vertexRef instanceof Vertex) {
            return ((Vertex)vertexRef).isGroup();
        }
        return false;
    }

    private static AlarmStatus createIndeterminateStatus() {
        return new AlarmStatus(OnmsSeverity.INDETERMINATE.getLabel(), 0L);
    }

    private static AlarmStatus calculateAlarmStatusForGroup(List<AlarmSummary> alarmSummaries) {
        if (!alarmSummaries.isEmpty()) {
            Collections.sort(alarmSummaries, new Comparator<AlarmSummary>(){

                @Override
                public int compare(AlarmSummary o1, AlarmSummary o2) {
                    return o1.getMaxSeverity().compareTo((Enum)o2.getMaxSeverity());
                }
            });
            OnmsSeverity severity = alarmSummaries.get(0).getMaxSeverity();
            int count = 0;
            for (AlarmSummary eachSummary : alarmSummaries) {
                count = (int)((long)count + eachSummary.getAlarmCount());
            }
            return new AlarmStatus(severity.getLabel(), count);
        }
        return AlarmStatusProvider.createIndeterminateStatus();
    }

    private static class AlarmStatus
    extends DefaultStatus {
        public AlarmStatus(String label, long count) {
            super(label, count);
        }
    }
}

