/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.EdgeListener;
import org.opennms.features.topology.api.topo.EdgeProvider;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.netmgt.dao.api.OspfElementDao;
import org.opennms.netmgt.dao.api.OspfLinkDao;
import org.opennms.netmgt.model.OspfLink;

public class OspfEdgeProvider
implements EdgeProvider {
    private OspfElementDao m_ospfElementDao;
    private OspfLinkDao m_ospfLinkDao;

    public String getEdgeNamespace() {
        return "nodes::OSPF";
    }

    public boolean contributesTo(String namespace) {
        return namespace.equals("nodes");
    }

    public Edge getEdge(String namespace, String id) {
        return null;
    }

    public Edge getEdge(EdgeRef reference) {
        return null;
    }

    public List<Edge> getEdges(Criteria ... criteria) {
        List allLinks = this.getOspfLinkDao().findAll();
        HashSet<AbstractEdge> combinedLinks = new HashSet<AbstractEdge>();
        for (OspfLink sourceLink : allLinks) {
            for (OspfLink targetLink : allLinks) {
                boolean ipAddrCheck = sourceLink.getOspfRemIpAddr().equals(targetLink.getOspfIpAddr()) && targetLink.getOspfRemIpAddr().equals(sourceLink.getOspfIpAddr());
                if (!ipAddrCheck) continue;
                String id = "ospf::" + Math.min(sourceLink.getId(), targetLink.getId()) + "||" + Math.max(sourceLink.getId(), targetLink.getId());
                AbstractVertex source = new AbstractVertex("nodes", sourceLink.getNode().getNodeId(), sourceLink.getNode().getLabel());
                AbstractVertex target = new AbstractVertex("nodes", targetLink.getNode().getNodeId(), targetLink.getNode().getLabel());
                AbstractEdge edge = new AbstractEdge(this.getEdgeNamespace(), id, (Vertex)source, (Vertex)target);
                combinedLinks.add(edge);
            }
        }
        return Arrays.asList(combinedLinks.toArray(new Edge[0]));
    }

    public List<Edge> getEdges(Collection<? extends EdgeRef> references) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addEdgeListener(EdgeListener listener) {
    }

    public void removeEdgeListener(EdgeListener listener) {
    }

    public void clearEdges() {
    }

    public OspfElementDao getOspfElementDao() {
        return this.m_ospfElementDao;
    }

    public void setOspfElementDao(OspfElementDao ospfElementDao) {
        this.m_ospfElementDao = ospfElementDao;
    }

    public OspfLinkDao getOspfLinkDao() {
        return this.m_ospfLinkDao;
    }

    public void setOspfLinkDao(OspfLinkDao ospfLinkDao) {
        this.m_ospfLinkDao = ospfLinkDao;
    }
}

