/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.opennms.features.topology.api.support.VertexHopGraphProvider;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.RefComparator;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;

public class LinkdHopCriteria
extends VertexHopGraphProvider.VertexHopCriteria {
    public static final String NAMESPACE = "nodes";
    private final String m_nodeId;
    private NodeDao m_nodeDao;

    public LinkdHopCriteria(String nodeId, NodeDao dao) {
        super(nodeId);
        this.m_nodeId = nodeId;
        this.m_nodeDao = dao;
    }

    public LinkdHopCriteria(String nodeId, String nodeLabel, NodeDao dao) {
        super(nodeLabel);
        this.setId(nodeId);
        this.m_nodeId = nodeId;
        this.m_nodeDao = dao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao dao) {
        this.m_nodeDao = dao;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_nodeId == null ? 0 : this.m_nodeId.hashCode());
        result = 31 * result + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof LinkdHopCriteria) {
            LinkdHopCriteria ref = (LinkdHopCriteria)((Object)obj);
            return ref.m_nodeId.equals(this.m_nodeId) && ref.getNamespace().equals(this.getNamespace());
        }
        return false;
    }

    public Set<VertexRef> getVertices() {
        Integer id = Integer.valueOf(this.m_nodeId);
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)id);
        TreeSet<VertexRef> vertices = new TreeSet<VertexRef>((Comparator<VertexRef>)new RefComparator());
        if (node != null) {
            String label = node.getLabel();
            vertices.add((VertexRef)new DefaultVertexRef(NAMESPACE, this.m_nodeId, label));
        }
        return vertices;
    }

    public static class LinkdVertex
    extends AbstractVertex {
        public LinkdVertex(String namespace, String id, String label) {
            super(namespace, id, label);
        }

        public boolean isGroup() {
            return false;
        }
    }
}

