/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.plugins.topo.linkd.internal.AbstractLinkStatusProvider;
import org.opennms.netmgt.dao.api.BridgeMacLinkDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.topology.BridgeMacTopologyLink;
import org.opennms.netmgt.model.topology.EdgeAlarmStatusSummary;

public class BridgeLinkStatusProvider
extends AbstractLinkStatusProvider {
    private BridgeMacLinkDao m_bridgeMackLinkDao;
    private Multimap<String, BridgeMacTopologyLink> m_multimapLinks;

    @Override
    public String getNameSpace() {
        return "nodes::BRIDGE";
    }

    @Override
    protected List<EdgeAlarmStatusSummary> getEdgeAlarmSummaries(List<Integer> linkIds) {
        HashMultimap summaryMap = HashMultimap.create();
        for (Object link : this.m_multimapLinks.values()) {
            String key = link.getNodeId() + ":" + link.getBridgePortIfIndex();
            if (!summaryMap.containsKey((Object)key)) {
                summaryMap.put((Object)key, (Object)new EdgeAlarmStatusSummary(link.getNodeId().intValue(), link.getBridgePort().intValue(), null));
            }
            if (link.getTargetNodeId() == null || link.getSourceIfIndex() == null) continue;
            summaryMap.put((Object)(link.getTargetNodeId() + ":" + link.getSourceIfIndex()), (Object)new EdgeAlarmStatusSummary(link.getNodeId().intValue(), link.getTargetNodeId().intValue(), null));
        }
        List<OnmsAlarm> alarms = this.getLinkDownAlarms();
        for (OnmsAlarm alarm : alarms) {
            String key = alarm.getNodeId() + ":" + alarm.getIfIndex();
            String cloudKey = alarm.getNodeId() + "|" + alarm.getIfIndex();
            if (!summaryMap.containsKey((Object)key)) continue;
            Collection summaries = summaryMap.get((Object)key);
            if (this.m_multimapLinks.containsKey((Object)cloudKey)) {
                for (BridgeMacTopologyLink link : this.m_multimapLinks.get((Object)cloudKey)) {
                    String indexKey = link.getTargetNodeId() + ":" + link.getSourceIfIndex();
                    summaries.addAll(summaryMap.get((Object)indexKey));
                }
            }
            for (EdgeAlarmStatusSummary summary : summaries) {
                summary.setEventUEI(alarm.getUei());
            }
        }
        ArrayList<EdgeAlarmStatusSummary> ret_val = new ArrayList<EdgeAlarmStatusSummary>();
        for (String summaryMapKey : summaryMap.keySet()) {
            ret_val.addAll(summaryMap.get((Object)summaryMapKey));
        }
        return ret_val;
    }

    @Override
    protected Set<Integer> getLinkIds(Map<String, EdgeRef> mappedRefs) {
        List bridgeMacLinks = this.m_bridgeMackLinkDao.getAllBridgeLinksToIpAddrToNodes();
        HashMultimap multimap = HashMultimap.create();
        for (BridgeMacTopologyLink macLink : bridgeMacLinks) {
            String idKey = String.valueOf(macLink.getNodeId()) + "|" + String.valueOf(macLink.getBridgePort());
            if (!mappedRefs.containsKey(idKey) || macLink.getTargetNodeId() == null || macLink.getSourceIfIndex() == null) continue;
            multimap.put((Object)idKey, (Object)macLink);
        }
        if (this.m_multimapLinks == null) {
            this.m_multimapLinks = HashMultimap.create();
        }
        this.m_multimapLinks.clear();
        this.m_multimapLinks.putAll((Multimap)multimap);
        HashSet<Integer> ret_val = new HashSet<Integer>();
        for (String key : multimap.keySet()) {
            Collection links = multimap.get((Object)key);
            for (BridgeMacTopologyLink link : links) {
                ret_val.add(link.getId());
            }
        }
        return ret_val;
    }

    public void setBridgeMacLinkDao(BridgeMacLinkDao bridgeMacLinkDao) {
        this.m_bridgeMackLinkDao = bridgeMacLinkDao;
    }
}

