/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.support.VertexHopGraphProvider;
import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.AbstractSearchProvider;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.SearchQuery;
import org.opennms.features.topology.api.topo.SearchResult;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.api.topo.WrappedGraph;
import org.opennms.features.topology.api.topo.WrappedVertex;
import org.opennms.features.topology.plugins.topo.linkd.internal.AbstractLinkdTopologyProvider;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdHopCriteria;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdHopCriteriaFactory;
import org.opennms.netmgt.dao.api.DataLinkInterfaceDao;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkdTopologyProvider
extends AbstractLinkdTopologyProvider {
    private static Logger LOG = LoggerFactory.getLogger(LinkdTopologyProvider.class);
    public static final String GROUP_ICON_KEY = "linkd:group";
    public static final String SERVER_ICON_KEY = "linkd:system";
    private DataLinkInterfaceDao m_dataLinkInterfaceDao;

    public DataLinkInterfaceDao getDataLinkInterfaceDao() {
        return this.m_dataLinkInterfaceDao;
    }

    public void setDataLinkInterfaceDao(DataLinkInterfaceDao dataLinkInterfaceDao) {
        this.m_dataLinkInterfaceDao = dataLinkInterfaceDao;
    }

    public void onInit() throws MalformedURLException, JAXBException {
        LOG.debug("init: loading topology.");
        this.load(null);
    }

    public void refresh() {
        try {
            this.load(null);
        }
        catch (MalformedURLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (JAXBException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void load(String filename) throws MalformedURLException, JAXBException {
        File configFile;
        if (filename != null) {
            LOG.warn("Filename that was specified for linkd topology will be ignored: " + filename + ", using " + this.getConfigurationFile() + " instead");
        }
        LOG.debug("loadtopology: resetContainer ");
        this.resetContainer();
        for (DataLinkInterface link : this.m_dataLinkInterfaceDao.findAll()) {
            LOG.debug("loadtopology: parsing link: " + link.getDataLinkInterfaceId());
            OnmsNode node = (OnmsNode)this.getNodeDao().get((Serializable)link.getNode().getId());
            LOG.debug("loadtopology: found source node: " + node.getLabel());
            String sourceId = node.getNodeId();
            Vertex source = this.getVertex(this.getVertexNamespace(), sourceId);
            if (source == null) {
                LOG.debug("loadtopology: adding source node as vertex: " + node.getLabel());
                source = this.getVertex(node);
                this.addVertices(new Vertex[]{source});
            }
            OnmsNode parentNode = (OnmsNode)this.getNodeDao().get((Serializable)link.getNodeParentId());
            LOG.debug("loadtopology: found target node: " + parentNode.getLabel());
            String targetId = parentNode.getNodeId();
            Vertex target = this.getVertex(this.getVertexNamespace(), targetId);
            if (target == null) {
                LOG.debug("loadtopology: adding target as vertex: " + parentNode.getLabel());
                target = this.getVertex(parentNode);
                this.addVertices(new Vertex[]{target});
            }
            AbstractEdge edge = this.connectVertices(link.getDataLinkInterfaceId(), (VertexRef)source, (VertexRef)target, this.getEdgeNamespace());
            edge.setTooltipText(this.getEdgeTooltipText(link, source, target));
        }
        LOG.debug("loadtopology: adding nodes without links: " + this.isAddNodeWithoutLink());
        if (this.isAddNodeWithoutLink()) {
            this.addNodesWithoutLinks();
        }
        if ((configFile = new File(this.getConfigurationFile())).exists() && configFile.canRead()) {
            LOG.debug("loadtopology: loading topology from configuration file: " + this.getConfigurationFile());
            WrappedGraph graph = LinkdTopologyProvider.getGraphFromFile(configFile);
            for (WrappedVertex eachVertexInFile : graph.m_vertices) {
                if (!eachVertexInFile.group) continue;
                LOG.debug("loadtopology: adding group to topology: " + eachVertexInFile.id);
                if (eachVertexInFile.namespace == null) {
                    eachVertexInFile.namespace = this.getVertexNamespace();
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Setting namespace on vertex to default: {}", (Object)eachVertexInFile);
                }
                if (eachVertexInFile.id == null) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Invalid vertex unmarshalled from {}: {}", (Object)this.getConfigurationFile(), (Object)eachVertexInFile);
                }
                AbstractVertex newGroupVertex = this.addGroup(eachVertexInFile.id, eachVertexInFile.iconKey, eachVertexInFile.label);
                newGroupVertex.setIpAddress(eachVertexInFile.ipAddr);
                newGroupVertex.setLocked(eachVertexInFile.locked);
                if (eachVertexInFile.nodeID != null) {
                    newGroupVertex.setNodeID(eachVertexInFile.nodeID);
                }
                if (!newGroupVertex.equals((Object)eachVertexInFile.parent)) {
                    newGroupVertex.setParent((VertexRef)eachVertexInFile.parent);
                }
                newGroupVertex.setSelected(eachVertexInFile.selected);
                newGroupVertex.setStyleName(eachVertexInFile.styleName);
                newGroupVertex.setTooltipText(eachVertexInFile.tooltipText);
                if (eachVertexInFile.x != null) {
                    newGroupVertex.setX(eachVertexInFile.x);
                }
                if (eachVertexInFile.y == null) continue;
                newGroupVertex.setY(eachVertexInFile.y);
            }
            for (Vertex vertex : this.getVertices(new Criteria[0])) {
                if (vertex.getParent() == null || vertex.equals(vertex.getParent())) continue;
                LOG.debug("loadtopology: setting parent of " + vertex + " to " + vertex.getParent());
                this.setParent((VertexRef)vertex, vertex.getParent());
            }
            for (WrappedVertex eachVertexInFile : graph.m_vertices) {
                if (eachVertexInFile.group || eachVertexInFile.parent == null) continue;
                Vertex child = this.getVertex((VertexRef)eachVertexInFile, new Criteria[0]);
                Vertex parent = this.getVertex((VertexRef)eachVertexInFile.parent, new Criteria[0]);
                if (child == null || parent == null) continue;
                LOG.debug("loadtopology: setting parent of " + child + " to " + parent);
                if (child.equals(parent)) continue;
                this.setParent((VertexRef)child, (VertexRef)parent);
            }
        } else {
            LOG.debug("loadtopology: could not load topology configFile:" + this.getConfigurationFile());
        }
        LOG.debug("Found " + this.getGroups().size() + " groups");
        LOG.debug("Found " + this.getVerticesWithoutGroups().size() + " vertices");
        LOG.debug("Found " + this.getEdges(new Criteria[0]).size() + " edges");
    }

    public String getSearchProviderNamespace() {
        return "nodes";
    }

    public List<SearchResult> slowQuery(SearchQuery searchQuery, GraphContainer graphContainer) {
        LOG.debug("SearchProvider->query: called with search query: '{}'", (Object)searchQuery);
        ArrayList searchResults = Lists.newArrayList();
        CriteriaBuilder cb = new CriteriaBuilder(OnmsNode.class);
        String ilike = "%" + searchQuery.getQueryString() + "%";
        cb.match("any").ilike("label", (Object)ilike).ilike("sysDescription", (Object)ilike);
        List nodes = this.getNodeDao().findMatching(cb.toCriteria());
        if (nodes.size() == 0) {
            return searchResults;
        }
        for (OnmsNode node : nodes) {
            searchResults.add(this.createSearchResult(node, searchQuery.getQueryString()));
        }
        return searchResults;
    }

    private SearchResult createSearchResult(OnmsNode node, String queryString) {
        return new SearchResult("node", node.getId().toString(), node.getLabel(), queryString);
    }

    public List<SearchResult> query(SearchQuery searchQuery, GraphContainer graphContainer) {
        List<Vertex> vertices = this.getFilteredVertices();
        ArrayList searchResults = Lists.newArrayList();
        for (Vertex vertex : vertices) {
            if (!searchQuery.matches(vertex.getLabel())) continue;
            searchResults.add(new SearchResult((VertexRef)vertex));
        }
        return searchResults;
    }

    public void onFocusSearchResult(SearchResult searchResult, OperationContext operationContext) {
        LOG.debug("SearchProvider->onFocusSearchResult: called with search result: '{}'", (Object)searchResult);
    }

    public void onDefocusSearchResult(SearchResult searchResult, OperationContext operationContext) {
        LOG.debug("SearchProvider->onDefocusSearchResult: called with search result: '{}'", (Object)searchResult);
    }

    public boolean supportsPrefix(String searchPrefix) {
        return AbstractSearchProvider.supportsPrefix((String)"nodes=", (String)searchPrefix);
    }

    public Set<VertexRef> getVertexRefsBy(SearchResult searchResult, GraphContainer container) {
        LOG.debug("SearchProvider->getVertexRefsBy: called with search result: '{}'", (Object)searchResult);
        Criteria criterion = this.findCriterion(searchResult.getId(), container);
        Set vertices = ((VertexHopGraphProvider.VertexHopCriteria)criterion).getVertices();
        LOG.debug("SearchProvider->getVertexRefsBy: found '{}' vertices.", (Object)vertices.size());
        return vertices;
    }

    public void removeVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        LOG.debug("SearchProvider->removeVertexHopCriteria: called with search result: '{}'", (Object)searchResult);
        Criteria criterion = this.findCriterion(searchResult.getId(), container);
        if (criterion != null) {
            LOG.debug("SearchProvider->removeVertexHopCriteria: found criterion: {} for searchResult {}.", (Object)criterion, (Object)searchResult);
            container.removeCriteria(criterion);
        } else {
            LOG.debug("SearchProvider->removeVertexHopCriteria: did not find criterion for searchResult {}.", (Object)searchResult);
        }
        this.logCriteriaInContainer(container);
    }

    private Criteria findCriterion(String resultId, GraphContainer container) {
        Criteria[] criteria;
        for (Criteria criterion : criteria = container.getCriteria()) {
            String id;
            if (criterion instanceof LinkdHopCriteria && (id = ((LinkdHopCriteria)criterion).getId()).equals(resultId)) {
                return criterion;
            }
            if (!(criterion instanceof VertexHopGraphProvider.FocusNodeHopCriteria) || !(id = ((VertexHopGraphProvider.FocusNodeHopCriteria)criterion).getId()).equals(resultId)) continue;
            return criterion;
        }
        return null;
    }

    public void onCenterSearchResult(SearchResult searchResult, GraphContainer graphContainer) {
        LOG.debug("SearchProvider->onCenterSearchResult: called with search result: '{}'", (Object)searchResult);
    }

    public void onToggleCollapse(SearchResult searchResult, GraphContainer graphContainer) {
        LOG.debug("SearchProvider->onToggleCollapse: called with search result: '{}'", (Object)searchResult);
    }

    public void addVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        LOG.debug("SearchProvider->addVertexHopCriteria: called with search result: '{}'", (Object)searchResult);
        VertexHopGraphProvider.VertexHopCriteria criterion = LinkdHopCriteriaFactory.createCriteria(searchResult.getId(), searchResult.getLabel());
        container.addCriteria((Criteria)criterion);
        LOG.debug("SearchProvider->addVertexHop: adding hop criteria {}.", (Object)criterion);
        this.logCriteriaInContainer(container);
    }

    private void logCriteriaInContainer(GraphContainer container) {
        Criteria[] criteria = container.getCriteria();
        LOG.debug("SearchProvider->addVertexHopCriteria: there are now {} criteria in the GraphContainer.", (Object)criteria.length);
        for (Criteria crit : criteria) {
            LOG.debug("SearchProvider->addVertexHopCriteria: criterion: '{}' is in the GraphContainer.", (Object)crit);
        }
    }
}

