/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import java.io.Serializable;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.plugins.topo.linkd.internal.AbstractLinkdTopologyProvider;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeferedNodeLeafVertex
extends AbstractVertex {
    private static Logger LOG = LoggerFactory.getLogger(DeferedNodeLeafVertex.class);
    private final AbstractLinkdTopologyProvider m_topologyProvider;
    private boolean m_onGetAlreadyCalled = false;

    public DeferedNodeLeafVertex(String namespace, Integer nodeId, String nodeLabel, AbstractLinkdTopologyProvider topologyProvider) {
        super(namespace, nodeId.toString(), nodeLabel);
        this.setNodeID(nodeId);
        this.setX(0);
        this.setY(0);
        this.m_topologyProvider = topologyProvider;
    }

    private synchronized void onGet() {
        if (this.m_onGetAlreadyCalled) {
            return;
        }
        this.m_onGetAlreadyCalled = true;
        LOG.debug("Loading node details for vertex: {}", (Object)this.getLabel());
        OnmsNode node = (OnmsNode)this.m_topologyProvider.getNodeDao().get((Serializable)this.getNodeID());
        this.setIconKey(AbstractLinkdTopologyProvider.getIconName(node));
        OnmsIpInterface ip = this.m_topologyProvider.getAddress(node);
        this.setIpAddress(ip == null ? null : ip.getIpAddress().getHostAddress());
        this.setTooltipText(AbstractLinkdTopologyProvider.getNodeTooltipText(node, this, ip));
    }

    public String getIconKey() {
        this.onGet();
        return super.getIconKey();
    }

    public String getIpAddress() {
        this.onGet();
        return super.getIpAddress();
    }

    public String getTooltipText() {
        this.onGet();
        return super.getTooltipText();
    }
}

