/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.plugins.topo.linkd.internal.AbstractLinkStatusProvider;
import org.opennms.netmgt.dao.api.BridgeBridgeLinkDao;
import org.opennms.netmgt.dao.api.BridgeMacLinkDao;
import org.opennms.netmgt.model.BridgeBridgeLink;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.topology.BridgeMacTopologyLink;
import org.opennms.netmgt.model.topology.EdgeAlarmStatusSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgeLinkStatusProvider
extends AbstractLinkStatusProvider {
    private static Logger LOG = LoggerFactory.getLogger(BridgeLinkStatusProvider.class);
    private BridgeMacLinkDao m_bridgeMacLinkDao;
    private BridgeBridgeLinkDao m_bridgeBridgeLinkDao;
    private Map<String, BridgeMacTopologyLink> m_macBridgeMacLinks;
    private Map<String, BridgeMacTopologyLink> m_bridgeBridgeMacLinks;
    private Map<String, BridgeBridgeLink> m_bridgeBridgeLinks;

    @Override
    public String getNameSpace() {
        return "nodes::BRIDGE";
    }

    @Override
    protected List<EdgeAlarmStatusSummary> getEdgeAlarmSummaries(List<Integer> linkIds) {
        BridgeBridgeLink link;
        HashMap<String, EdgeAlarmStatusSummary> alarmMap = new HashMap<String, EdgeAlarmStatusSummary>();
        for (String key : this.m_bridgeBridgeLinks.keySet()) {
            link = this.m_bridgeBridgeLinks.get(key);
            alarmMap.put(key, new EdgeAlarmStatusSummary(key, link.getId().intValue(), link.getId().intValue(), null));
        }
        for (String key : this.m_bridgeBridgeMacLinks.keySet()) {
            link = this.m_bridgeBridgeMacLinks.get(key);
            alarmMap.put(key, new EdgeAlarmStatusSummary(key, link.getId(), link.getId(), null));
        }
        for (String key : this.m_macBridgeMacLinks.keySet()) {
            link = this.m_macBridgeMacLinks.get(key);
            alarmMap.put(key, new EdgeAlarmStatusSummary(key, link.getId(), link.getId(), null));
        }
        for (OnmsAlarm alarm : this.getLinkDownAlarms()) {
            BridgeBridgeLink link2;
            LOG.debug("getEdgeAlarmSummaries: alarm: nodeid {} ifindex {} uei {}", new Object[]{alarm.getNodeId(), alarm.getIfIndex(), alarm.getUei()});
            for (String key : this.m_bridgeBridgeLinks.keySet()) {
                link2 = this.m_bridgeBridgeLinks.get(key);
                LOG.debug("getEdgeAlarmSummaries: key {} bridgebridgelink: {} ", (Object)key, (Object)link2.getId());
                if (alarm.getNodeId() == link2.getNode().getId()) {
                    if (link2.getBridgePortIfIndex() != 0) {
                        if (alarm.getIfIndex() != link2.getBridgePortIfIndex()) continue;
                        ((EdgeAlarmStatusSummary)alarmMap.get(key)).setEventUEI(alarm.getUei());
                        LOG.debug("getEdgeAlarmSummaries: matchted source bridgebridgelink id {} key {}", (Object)link2.getId(), (Object)key);
                        continue;
                    }
                    if (alarm.getIfIndex() != link2.getBridgePort()) continue;
                    ((EdgeAlarmStatusSummary)alarmMap.get(key)).setEventUEI(alarm.getUei());
                    LOG.debug("getEdgeAlarmSummaries: matchted source bridgebridgelink id {} key {}", (Object)link2.getId(), (Object)key);
                    continue;
                }
                if (alarm.getNodeId() != link2.getDesignatedNode().getId()) continue;
                if (link2.getDesignatedPortIfIndex() != 0) {
                    if (alarm.getIfIndex() != link2.getDesignatedPortIfIndex()) continue;
                    ((EdgeAlarmStatusSummary)alarmMap.get(key)).setEventUEI(alarm.getUei());
                    LOG.debug("getEdgeAlarmSummaries: matchted target bridgebridgelink id {} key {}", (Object)link2.getId(), (Object)key);
                    continue;
                }
                if (alarm.getIfIndex() != link2.getDesignatedPort()) continue;
                ((EdgeAlarmStatusSummary)alarmMap.get(key)).setEventUEI(alarm.getUei());
                LOG.debug("getEdgeAlarmSummaries: matchted target bridgebridgelink id {} key {}", (Object)link2.getId(), (Object)key);
            }
            for (String key : this.m_bridgeBridgeMacLinks.keySet()) {
                link2 = this.m_bridgeBridgeMacLinks.get(key);
                LOG.debug("getEdgeAlarmSummaries: key {} bridge bridgemaclink: {} ", (Object)key, (Object)link2.getId());
                String sourceLink = EdgeAlarmStatusSummary.getDefaultEdgeId((int)link2.getId(), (int)link2.getId());
                String targetLink = EdgeAlarmStatusSummary.getDefaultEdgeId((int)link2.getTargetId(), (int)link2.getTargetId());
                LOG.debug("getEdgeAlarmSummaries: sourcelinkid: {}", (Object)sourceLink);
                LOG.debug("getEdgeAlarmSummaries: targetLinkId: {}", (Object)targetLink);
                if (alarm.getNodeId() == link2.getSrcNodeId() && sourceLink.equals(key)) {
                    if (link2.getBridgePortIfIndex() != 0) {
                        if (alarm.getIfIndex() != link2.getBridgePortIfIndex()) continue;
                        ((EdgeAlarmStatusSummary)alarmMap.get(key)).setEventUEI(alarm.getUei());
                        LOG.debug("getEdgeAlarmSummaries: matchted source bridgebridgelink id {} key {}", (Object)link2.getId(), (Object)key);
                        continue;
                    }
                    if (alarm.getIfIndex() != link2.getBridgePort()) continue;
                    ((EdgeAlarmStatusSummary)alarmMap.get(key)).setEventUEI(alarm.getUei());
                    LOG.debug("getEdgeAlarmSummaries: matchted source bridgebridgelink id {} key {}", (Object)link2.getId(), (Object)key);
                    continue;
                }
                if (alarm.getNodeId() != link2.getTargetNodeId() || !targetLink.equals(key)) continue;
                if (link2.getTargetIfIndex() != 0) {
                    if (alarm.getIfIndex() != link2.getTargetIfIndex()) continue;
                    ((EdgeAlarmStatusSummary)alarmMap.get(key)).setEventUEI(alarm.getUei());
                    LOG.debug("getEdgeAlarmSummaries: matchted target bridgebridgelink id {} key {}", (Object)link2.getId(), (Object)key);
                    continue;
                }
                if (alarm.getIfIndex() != link2.getTargetBridgePort()) continue;
                ((EdgeAlarmStatusSummary)alarmMap.get(key)).setEventUEI(alarm.getUei());
                LOG.debug("getEdgeAlarmSummaries: matchted target bridgebridgelink id {} key {}", (Object)link2.getId(), (Object)key);
            }
            for (String key : this.m_macBridgeMacLinks.keySet()) {
                link2 = this.m_macBridgeMacLinks.get(key);
                LOG.debug("getEdgeAlarmSummaries: key {} bridgemaclink: {} ", (Object)key, (Object)link2.getId());
                String targetLink = String.valueOf(link2.getId() + "|" + String.valueOf(link2.getTargetId()));
                LOG.debug("getEdgeAlarmSummaries: targetLinkId: {}", (Object)targetLink);
                if (alarm.getNodeId() == link2.getSrcNodeId()) {
                    if (link2.getBridgePortIfIndex() != 0) {
                        if (alarm.getIfIndex() != link2.getBridgePortIfIndex()) continue;
                        ((EdgeAlarmStatusSummary)alarmMap.get(key)).setEventUEI(alarm.getUei());
                        LOG.debug("getEdgeAlarmSummaries: matchted source bridgebridgelink id {} key {}", (Object)link2.getId(), (Object)key);
                        continue;
                    }
                    if (alarm.getIfIndex() != link2.getBridgePort()) continue;
                    ((EdgeAlarmStatusSummary)alarmMap.get(key)).setEventUEI(alarm.getUei());
                    LOG.debug("getEdgeAlarmSummaries: matchted source bridgebridgelink id {} key {}", (Object)link2.getId(), (Object)key);
                    continue;
                }
                if (alarm.getNodeId() != link2.getTargetNodeId() || !targetLink.equals(key)) continue;
                if (link2.getTargetIfIndex() == null) {
                    ((EdgeAlarmStatusSummary)alarmMap.get(key)).setEventUEI(alarm.getUei());
                    LOG.debug("getEdgeAlarmSummaries: matchted target bridgebridgelink id {} key {}", (Object)link2.getId(), (Object)key);
                    continue;
                }
                if (alarm.getIfIndex() != link2.getTargetIfIndex()) continue;
                ((EdgeAlarmStatusSummary)alarmMap.get(key)).setEventUEI(alarm.getUei());
                LOG.debug("getEdgeAlarmSummaries: matchted target bridgebridgelink id {} key {}", (Object)link2.getId(), (Object)key);
            }
        }
        ArrayList<EdgeAlarmStatusSummary> ret_val = new ArrayList<EdgeAlarmStatusSummary>();
        ret_val.addAll(alarmMap.values());
        return ret_val;
    }

    @Override
    protected Set<Integer> getLinkIds(Map<String, EdgeRef> mappedRefs) {
        HashMap<String, BridgeBridgeLink> mapA = new HashMap<String, BridgeBridgeLink>();
        for (BridgeBridgeLink link : this.m_bridgeBridgeLinkDao.findAll()) {
            String idKey = EdgeAlarmStatusSummary.getDefaultEdgeId((int)link.getId(), (int)link.getId());
            LOG.debug("getLinkIds: parsing key {} bridgebridgelink: {} ", (Object)idKey, (Object)link.getId());
            if (!mappedRefs.containsKey(idKey)) continue;
            LOG.debug("getLinkIds: adding matched key {} bridgebridgelink: {} ", (Object)idKey, (Object)link.getId());
            mapA.put(idKey, link);
        }
        HashMap<String, BridgeMacTopologyLink> mapB = new HashMap<String, BridgeMacTopologyLink>();
        for (BridgeMacTopologyLink link : this.m_bridgeMacLinkDao.getAllBridgeLinksToBridgeNodes()) {
            String idKey = EdgeAlarmStatusSummary.getDefaultEdgeId((int)link.getTargetId(), (int)link.getTargetId());
            LOG.debug("getLinkIds: parsing key {} bridge bridgemaclink: {} ", (Object)idKey, (Object)link.getId());
            if (mappedRefs.containsKey(idKey)) {
                LOG.debug("getLinkIds: adding matched key {} bridge bridgemaclink: {} ", (Object)idKey, (Object)link.getId());
                mapB.put(idKey, link);
            }
            idKey = EdgeAlarmStatusSummary.getDefaultEdgeId((int)link.getId(), (int)link.getId());
            LOG.debug("getLinkIds: parsing key {} bridge bridgemaclink: {} ", (Object)idKey, (Object)link.getId());
            if (!mappedRefs.containsKey(idKey)) continue;
            LOG.debug("getLinkIds: adding matched key {} bridge bridgemaclink: {} ", (Object)idKey, (Object)link.getId());
            mapB.put(idKey, link);
        }
        HashMap<String, BridgeMacTopologyLink> mapC = new HashMap<String, BridgeMacTopologyLink>();
        for (BridgeMacTopologyLink link : this.m_bridgeMacLinkDao.getAllBridgeLinksToIpAddrToNodes()) {
            String idKey = String.valueOf(link.getId()) + "|" + String.valueOf(link.getTargetId());
            LOG.debug("getLinkIds: parsing key {} mac bridgemaclink: {} ", (Object)idKey, (Object)link.getId());
            if (mappedRefs.containsKey(idKey)) {
                LOG.debug("getLinkIds: adding matched key {} mac bridgemaclink: {} ", (Object)idKey, (Object)link.getId());
                mapC.put(idKey, link);
            }
            idKey = EdgeAlarmStatusSummary.getDefaultEdgeId((int)link.getId(), (int)link.getId());
            LOG.debug("getLinkIds: parsing key {} mac bridgemaclink: {} ", (Object)idKey, (Object)link.getId());
            if (!mappedRefs.containsKey(idKey)) continue;
            LOG.debug("getLinkIds: adding matched key {} mac bridgemaclink: {} ", (Object)idKey, (Object)link.getId());
            mapC.put(idKey, link);
        }
        if (this.m_bridgeBridgeLinks == null) {
            this.m_bridgeBridgeLinks = new HashMap<String, BridgeBridgeLink>();
        }
        this.m_bridgeBridgeLinks.clear();
        this.m_bridgeBridgeLinks.putAll(mapA);
        if (this.m_bridgeBridgeMacLinks == null) {
            this.m_bridgeBridgeMacLinks = new HashMap<String, BridgeMacTopologyLink>();
        }
        this.m_bridgeBridgeMacLinks.clear();
        this.m_bridgeBridgeMacLinks.putAll(mapB);
        if (this.m_macBridgeMacLinks == null) {
            this.m_macBridgeMacLinks = new HashMap<String, BridgeMacTopologyLink>();
        }
        this.m_macBridgeMacLinks.clear();
        this.m_macBridgeMacLinks.putAll(mapC);
        HashSet<Integer> ret_val = new HashSet<Integer>();
        for (BridgeBridgeLink link : mapA.values()) {
            ret_val.add(link.getId());
        }
        for (BridgeBridgeLink link : mapB.values()) {
            ret_val.add(link.getId());
        }
        for (BridgeBridgeLink link : mapC.values()) {
            ret_val.add(link.getId());
        }
        LOG.debug("getLinkIds {}", ret_val);
        return ret_val;
    }

    public BridgeMacLinkDao getBridgeMacLinkDao() {
        return this.m_bridgeMacLinkDao;
    }

    public void setBridgeMacLinkDao(BridgeMacLinkDao bridgeMacLinkDao) {
        this.m_bridgeMacLinkDao = bridgeMacLinkDao;
    }

    public BridgeBridgeLinkDao getBridgeBridgeLinkDao() {
        return this.m_bridgeBridgeLinkDao;
    }

    public void setBridgeBridgeLinkDao(BridgeBridgeLinkDao bridgeBridgeLinkDao) {
        this.m_bridgeBridgeLinkDao = bridgeBridgeLinkDao;
    }
}

