/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.support.VertexHopGraphProvider;
import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.AbstractSearchProvider;
import org.opennms.features.topology.api.topo.AbstractTopologyProvider;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.SearchProvider;
import org.opennms.features.topology.api.topo.SearchQuery;
import org.opennms.features.topology.api.topo.SearchResult;
import org.opennms.features.topology.api.topo.SimpleLeafVertex;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.api.topo.WrappedEdge;
import org.opennms.features.topology.api.topo.WrappedGraph;
import org.opennms.features.topology.api.topo.WrappedGroup;
import org.opennms.features.topology.api.topo.WrappedLeafVertex;
import org.opennms.features.topology.api.topo.WrappedVertex;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdHopCriteria;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdHopCriteriaFactory;
import org.opennms.netmgt.dao.api.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.dao.api.TopologyDao;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.FilterManager;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkdTopologyProvider
extends AbstractTopologyProvider
implements GraphProvider,
SearchProvider {
    private static Logger LOG = LoggerFactory.getLogger(LinkdTopologyProvider.class);
    public static final String TOPOLOGY_NAMESPACE_LINKD = "nodes";
    public static final String GROUP_ICON_KEY = "linkd:group";
    public static final String SERVER_ICON_KEY = "linkd:system";
    private static final String HTML_TOOLTIP_TAG_OPEN = "<p>";
    private static final String HTML_TOOLTIP_TAG_END = "</p>";
    private static final DecimalFormat s_oneDigitAfterDecimal = new DecimalFormat("0.0##");
    private static final DecimalFormat s_noDigitsAfterDecimal = new DecimalFormat("0");
    private static final EnumMap<OnmsNode.NodeType, String> m_nodeStatusMap = new EnumMap(OnmsNode.NodeType.class);
    static final String[] OPER_ADMIN_STATUS;
    private boolean addNodeWithoutLink = false;
    private DataLinkInterfaceDao m_dataLinkInterfaceDao;
    private NodeDao m_nodeDao;
    private SnmpInterfaceDao m_snmpInterfaceDao;
    private IpInterfaceDao m_ipInterfaceDao;
    private TopologyDao m_topologyDao;
    private String m_configurationFile;
    private final boolean m_aclEnabled;
    private FilterManager m_filterManager;
    private LinkdHopCriteriaFactory m_criteriaHopFactory;

    public String getConfigurationFile() {
        return this.m_configurationFile;
    }

    public void setConfigurationFile(String configurationFile) {
        this.m_configurationFile = configurationFile;
    }

    public SnmpInterfaceDao getSnmpInterfaceDao() {
        return this.m_snmpInterfaceDao;
    }

    public void setSnmpInterfaceDao(SnmpInterfaceDao snmpInterfaceDao) {
        this.m_snmpInterfaceDao = snmpInterfaceDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public boolean isAddNodeWithoutLink() {
        return this.addNodeWithoutLink;
    }

    public void setAddNodeWithoutLink(boolean addNodeWithoutLink) {
        this.addNodeWithoutLink = addNodeWithoutLink;
    }

    public DataLinkInterfaceDao getDataLinkInterfaceDao() {
        return this.m_dataLinkInterfaceDao;
    }

    public void setDataLinkInterfaceDao(DataLinkInterfaceDao dataLinkInterfaceDao) {
        this.m_dataLinkInterfaceDao = dataLinkInterfaceDao;
    }

    public void setTopologyDao(TopologyDao topologyDao) {
        this.m_topologyDao = topologyDao;
    }

    public void setFilterManager(FilterManager filterManager) {
        this.m_filterManager = filterManager;
    }

    public FilterManager getFilterManager() {
        return this.m_filterManager;
    }

    public LinkdHopCriteriaFactory getLinkdHopCriteriaFactory() {
        return this.m_criteriaHopFactory;
    }

    public void setLinkdHopCriteriaFactory(LinkdHopCriteriaFactory factory) {
        this.m_criteriaHopFactory = factory;
    }

    public void onInit() throws MalformedURLException, JAXBException {
        LOG.debug("init: loading topology.");
        this.load(null);
    }

    public LinkdTopologyProvider() {
        super(TOPOLOGY_NAMESPACE_LINKD);
        String aclsProp = System.getProperty("org.opennms.web.aclsEnabled");
        this.m_aclEnabled = aclsProp != null ? aclsProp.equals("true") : false;
    }

    private static WrappedGraph getGraphFromFile(File file) throws JAXBException, MalformedURLException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{WrappedGraph.class});
        Unmarshaller u = jc.createUnmarshaller();
        return (WrappedGraph)u.unmarshal(file.toURI().toURL());
    }

    public void refresh() {
        try {
            this.load(null);
        }
        catch (MalformedURLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (JAXBException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void load(String filename) throws MalformedURLException, JAXBException {
        File configFile;
        if (filename != null) {
            LOG.warn("Filename that was specified for linkd topology will be ignored: " + filename + ", using " + this.m_configurationFile + " instead");
        }
        LOG.debug("loadtopology: resetContainer ");
        this.resetContainer();
        for (DataLinkInterface link : this.m_dataLinkInterfaceDao.findAll()) {
            LOG.debug("loadtopology: parsing link: " + link.getDataLinkInterfaceId());
            OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)link.getNode().getId());
            LOG.debug("loadtopology: found source node: " + node.getLabel());
            String sourceId = node.getNodeId();
            Vertex source = this.getVertex(this.getVertexNamespace(), sourceId);
            if (source == null) {
                LOG.debug("loadtopology: adding source node as vertex: " + node.getLabel());
                source = this.getVertex(node);
                this.addVertices(new Vertex[]{source});
            }
            OnmsNode parentNode = (OnmsNode)this.m_nodeDao.get((Serializable)link.getNodeParentId());
            LOG.debug("loadtopology: found target node: " + parentNode.getLabel());
            String targetId = parentNode.getNodeId();
            Vertex target = this.getVertex(this.getVertexNamespace(), targetId);
            if (target == null) {
                LOG.debug("loadtopology: adding target as vertex: " + parentNode.getLabel());
                target = this.getVertex(parentNode);
                this.addVertices(new Vertex[]{target});
            }
            AbstractEdge edge = this.connectVertices(link.getDataLinkInterfaceId(), (VertexRef)source, (VertexRef)target);
            edge.setTooltipText(this.getEdgeTooltipText(link, source, target));
        }
        LOG.debug("loadtopology: adding nodes without links: " + this.isAddNodeWithoutLink());
        if (this.isAddNodeWithoutLink()) {
            List<OnmsNode> allNodes = this.getAllNodesNoACL();
            for (OnmsNode onmsnode : allNodes) {
                String nodeId = onmsnode.getNodeId();
                if (this.getVertex(this.getVertexNamespace(), nodeId) != null) continue;
                LOG.debug("loadtopology: adding link-less node: " + onmsnode.getLabel());
                this.addVertices(new Vertex[]{this.getVertex(onmsnode)});
            }
        }
        if ((configFile = new File(this.m_configurationFile)).exists() && configFile.canRead()) {
            LOG.debug("loadtopology: loading topology from configuration file: " + this.m_configurationFile);
            WrappedGraph graph = LinkdTopologyProvider.getGraphFromFile(configFile);
            for (WrappedVertex eachVertexInFile : graph.m_vertices) {
                if (!eachVertexInFile.group) continue;
                LOG.debug("loadtopology: adding group to topology: " + eachVertexInFile.id);
                if (eachVertexInFile.namespace == null) {
                    eachVertexInFile.namespace = this.getVertexNamespace();
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Setting namespace on vertex to default: {}", (Object)eachVertexInFile);
                }
                if (eachVertexInFile.id == null) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Invalid vertex unmarshalled from {}: {}", (Object)this.m_configurationFile, (Object)eachVertexInFile);
                }
                AbstractVertex newGroupVertex = this.addGroup(eachVertexInFile.id, eachVertexInFile.iconKey, eachVertexInFile.label);
                newGroupVertex.setIpAddress(eachVertexInFile.ipAddr);
                newGroupVertex.setLocked(eachVertexInFile.locked);
                if (eachVertexInFile.nodeID != null) {
                    newGroupVertex.setNodeID(eachVertexInFile.nodeID);
                }
                if (!newGroupVertex.equals((Object)eachVertexInFile.parent)) {
                    newGroupVertex.setParent((VertexRef)eachVertexInFile.parent);
                }
                newGroupVertex.setSelected(eachVertexInFile.selected);
                newGroupVertex.setStyleName(eachVertexInFile.styleName);
                newGroupVertex.setTooltipText(eachVertexInFile.tooltipText);
                if (eachVertexInFile.x != null) {
                    newGroupVertex.setX(eachVertexInFile.x);
                }
                if (eachVertexInFile.y == null) continue;
                newGroupVertex.setY(eachVertexInFile.y);
            }
            for (Vertex vertex : this.getVertices(new Criteria[0])) {
                if (vertex.getParent() == null || vertex.equals(vertex.getParent())) continue;
                LOG.debug("loadtopology: setting parent of " + vertex + " to " + vertex.getParent());
                this.setParent((VertexRef)vertex, vertex.getParent());
            }
            for (WrappedVertex eachVertexInFile : graph.m_vertices) {
                if (eachVertexInFile.group || eachVertexInFile.parent == null) continue;
                Vertex child = this.getVertex((VertexRef)eachVertexInFile, new Criteria[0]);
                Vertex parent = this.getVertex((VertexRef)eachVertexInFile.parent, new Criteria[0]);
                if (child == null || parent == null) continue;
                LOG.debug("loadtopology: setting parent of " + child + " to " + parent);
                if (child.equals(parent)) continue;
                this.setParent((VertexRef)child, (VertexRef)parent);
            }
        } else {
            LOG.debug("loadtopology: could not load topology configFile:" + this.m_configurationFile);
        }
        LOG.debug("Found " + this.getGroups().size() + " groups");
        LOG.debug("Found " + this.getVerticesWithoutGroups().size() + " vertices");
        LOG.debug("Found " + this.getEdges(new Criteria[0]).size() + " edges");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OnmsNode> getAllNodesNoACL() {
        if (this.getFilterManager().isEnabled()) {
            String[] userGroups = this.getFilterManager().getAuthorizationGroups();
            List<OnmsNode> nodeList = null;
            try {
                this.getFilterManager().disableAuthorizationFilter();
                nodeList = this.m_nodeDao.findAll();
            }
            finally {
                if (userGroups != null) {
                    this.getFilterManager().enableAuthorizationFilter(userGroups);
                }
            }
            return nodeList != null ? nodeList : Collections.emptyList();
        }
        return this.m_nodeDao.findAll();
    }

    private AbstractVertex getVertex(OnmsNode onmsnode) {
        OnmsIpInterface ip = this.getAddress(onmsnode);
        SimpleLeafVertex vertex = new SimpleLeafVertex(TOPOLOGY_NAMESPACE_LINKD, onmsnode.getNodeId(), Integer.valueOf(0), Integer.valueOf(0));
        vertex.setIconKey(LinkdTopologyProvider.getIconName(onmsnode));
        vertex.setLabel(onmsnode.getLabel());
        vertex.setIpAddress(ip == null ? null : ip.getIpAddress().getHostAddress());
        vertex.setNodeID(Integer.valueOf(Integer.parseInt(onmsnode.getNodeId())));
        vertex.setTooltipText(LinkdTopologyProvider.getNodeTooltipText(onmsnode, (AbstractVertex)vertex, ip));
        return vertex;
    }

    private OnmsIpInterface getAddress(OnmsNode node) {
        OnmsIpInterface ip;
        block0: {
            OnmsIpInterface iterip;
            Iterator i$;
            ip = this.m_ipInterfaceDao.findPrimaryInterfaceByNodeId(node.getId());
            if (ip != null || !(i$ = this.m_ipInterfaceDao.findByNodeId(node.getId()).iterator()).hasNext()) break block0;
            ip = iterip = (OnmsIpInterface)i$.next();
        }
        return ip;
    }

    private String getEdgeTooltipText(DataLinkInterface link, Vertex source, Vertex target) {
        StringBuffer tooltipText = new StringBuffer();
        OnmsSnmpInterface sourceInterface = this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(Integer.parseInt(source.getId())), link.getIfIndex());
        OnmsSnmpInterface targetInterface = this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(Integer.parseInt(target.getId())), link.getParentIfIndex());
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        if (sourceInterface != null && targetInterface != null && sourceInterface.getNetMask() != null && !sourceInterface.getNetMask().isLoopbackAddress() && targetInterface.getNetMask() != null && !targetInterface.getNetMask().isLoopbackAddress()) {
            tooltipText.append("Type of Link: Layer3/Layer2");
        } else {
            tooltipText.append("Type of Link: Layer2");
        }
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append("Name: &lt;endpoint1 " + source.getLabel());
        if (sourceInterface != null) {
            tooltipText.append(":" + sourceInterface.getIfName());
        }
        tooltipText.append(" ---- endpoint2 " + target.getLabel());
        if (targetInterface != null) {
            tooltipText.append(":" + targetInterface.getIfName());
        }
        tooltipText.append("&gt;");
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        LinkStateMachine stateMachine = new LinkStateMachine();
        stateMachine.setParentInterfaces(sourceInterface, targetInterface);
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append("Link status: " + stateMachine.getLinkStatus());
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        if (targetInterface != null) {
            if (targetInterface.getIfSpeed() != null) {
                tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
                tooltipText.append("Bandwidth: " + LinkdTopologyProvider.getHumanReadableIfSpeed(targetInterface.getIfSpeed()));
                tooltipText.append(HTML_TOOLTIP_TAG_END);
            }
        } else if (sourceInterface != null && sourceInterface.getIfSpeed() != null) {
            tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
            tooltipText.append("Bandwidth: " + LinkdTopologyProvider.getHumanReadableIfSpeed(sourceInterface.getIfSpeed()));
            tooltipText.append(HTML_TOOLTIP_TAG_END);
        }
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append("End Point 1: " + source.getLabel() + ", " + source.getIpAddress());
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append("End Point 2: " + target.getLabel() + ", " + target.getIpAddress());
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        return tooltipText.toString();
    }

    private static String getNodeTooltipText(OnmsNode node, AbstractVertex vertex, OnmsIpInterface ip) {
        StringBuffer tooltipText = new StringBuffer();
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append("Management IP and Name: " + vertex.getIpAddress() + " (" + vertex.getLabel() + ")");
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        if (node.getSysLocation() != null && node.getSysLocation().length() > 0) {
            tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
            tooltipText.append("Location: " + node.getSysLocation());
            tooltipText.append(HTML_TOOLTIP_TAG_END);
        }
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append("Status: " + LinkdTopologyProvider.getNodeStatusString(node.getType()));
        if (ip != null && ip.isManaged()) {
            tooltipText.append(" / Managed");
        } else {
            tooltipText.append(" / Unmanaged");
        }
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        return tooltipText.toString();
    }

    public static String getIconName(OnmsNode node) {
        return node.getSysObjectId() == null ? SERVER_ICON_KEY : "linkd:system:snmp:" + node.getSysObjectId();
    }

    public void save() {
        ArrayList<Object> vertices = new ArrayList<Object>();
        for (Vertex vertex : this.getVertices(new Criteria[0])) {
            if (vertex.isGroup()) {
                vertices.add(new WrappedGroup(vertex));
                continue;
            }
            vertices.add(new WrappedLeafVertex(vertex));
        }
        ArrayList<WrappedEdge> edges = new ArrayList<WrappedEdge>();
        for (Edge edge : this.getEdges(new Criteria[0])) {
            WrappedEdge newEdge = new WrappedEdge(edge, (WrappedVertex)new WrappedLeafVertex(this.m_vertexProvider.getVertex(edge.getSource().getVertex(), new Criteria[0])), (WrappedVertex)new WrappedLeafVertex(this.m_vertexProvider.getVertex(edge.getTarget().getVertex(), new Criteria[0])));
            edges.add(newEdge);
        }
        WrappedGraph graph = new WrappedGraph(this.getEdgeNamespace(), vertices, edges);
        JAXB.marshal((Object)graph, (File)new File(this.m_configurationFile));
    }

    public String getSearchProviderNamespace() {
        return TOPOLOGY_NAMESPACE_LINKD;
    }

    public List<SearchResult> slowQuery(SearchQuery searchQuery, GraphContainer graphContainer) {
        LOG.debug("SearchProvider->query: called with search query: '{}'", (Object)searchQuery);
        ArrayList searchResults = Lists.newArrayList();
        CriteriaBuilder cb = new CriteriaBuilder(OnmsNode.class);
        String ilike = "%" + searchQuery.getQueryString() + "%";
        cb.match("any").ilike("label", (Object)ilike).ilike("sysDescription", (Object)ilike);
        List nodes = this.m_nodeDao.findMatching(cb.toCriteria());
        if (nodes.size() == 0) {
            return searchResults;
        }
        for (OnmsNode node : nodes) {
            searchResults.add(this.createSearchResult(node, searchQuery.getQueryString()));
        }
        return searchResults;
    }

    private SearchResult createSearchResult(OnmsNode node, String queryString) {
        SearchResult result = new SearchResult("node", node.getId().toString(), node.getLabel(), queryString);
        return result;
    }

    public List<SearchResult> query(SearchQuery searchQuery, GraphContainer graphContainer) {
        List<Vertex> vertices = this.getFilteredVertices();
        ArrayList searchResults = Lists.newArrayList();
        for (Vertex vertex : vertices) {
            if (!searchQuery.matches(vertex.getLabel())) continue;
            searchResults.add(new SearchResult((VertexRef)vertex));
        }
        return searchResults;
    }

    private List<Vertex> getFilteredVertices() {
        if (this.m_aclEnabled) {
            List onmsNodes = this.m_nodeDao.findAll();
            final List nodes = Lists.transform((List)onmsNodes, (Function)new Function<OnmsNode, Integer>(){

                public Integer apply(OnmsNode node) {
                    return node.getId();
                }
            });
            return Lists.newArrayList((Iterable)Collections2.filter((Collection)this.m_vertexProvider.getVertices(new Criteria[0]), (Predicate)new Predicate<Vertex>(){

                public boolean apply(Vertex vertex) {
                    return nodes.contains(vertex.getNodeID());
                }
            }));
        }
        return this.m_vertexProvider.getVertices(new Criteria[0]);
    }

    public void onFocusSearchResult(SearchResult searchResult, OperationContext operationContext) {
        LOG.debug("SearchProvider->onFocusSearchResult: called with search result: '{}'", (Object)searchResult);
    }

    public void onDefocusSearchResult(SearchResult searchResult, OperationContext operationContext) {
        LOG.debug("SearchProvider->onDefocusSearchResult: called with search result: '{}'", (Object)searchResult);
    }

    public boolean supportsPrefix(String searchPrefix) {
        return AbstractSearchProvider.supportsPrefix((String)"nodes=", (String)searchPrefix);
    }

    public Set<VertexRef> getVertexRefsBy(SearchResult searchResult, GraphContainer container) {
        LOG.debug("SearchProvider->getVertexRefsBy: called with search result: '{}'", (Object)searchResult);
        Criteria criterion = this.findCriterion(searchResult.getId(), container);
        Set vertices = ((VertexHopGraphProvider.VertexHopCriteria)criterion).getVertices();
        LOG.debug("SearchProvider->getVertexRefsBy: found '{}' vertices.", (Object)vertices.size());
        return vertices;
    }

    public void removeVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        LOG.debug("SearchProvider->removeVertexHopCriteria: called with search result: '{}'", (Object)searchResult);
        Criteria criterion = this.findCriterion(searchResult.getId(), container);
        if (criterion != null) {
            LOG.debug("SearchProvider->removeVertexHopCriteria: found criterion: {} for searchResult {}.", (Object)criterion, (Object)searchResult);
            container.removeCriteria(criterion);
        } else {
            LOG.debug("SearchProvider->removeVertexHopCriteria: did not find criterion for searchResult {}.", (Object)searchResult);
        }
        this.logCriteriaInContainer(container);
    }

    private Criteria findCriterion(String resultId, GraphContainer container) {
        Criteria[] criteria;
        for (Criteria criterion : criteria = container.getCriteria()) {
            String id;
            if (criterion instanceof LinkdHopCriteria && (id = ((LinkdHopCriteria)criterion).getId()).equals(resultId)) {
                return criterion;
            }
            if (!(criterion instanceof VertexHopGraphProvider.FocusNodeHopCriteria) || !(id = ((VertexHopGraphProvider.FocusNodeHopCriteria)criterion).getId()).equals(resultId)) continue;
            return criterion;
        }
        return null;
    }

    public void onCenterSearchResult(SearchResult searchResult, GraphContainer graphContainer) {
        LOG.debug("SearchProvider->onCenterSearchResult: called with search result: '{}'", (Object)searchResult);
    }

    public void onToggleCollapse(SearchResult searchResult, GraphContainer graphContainer) {
        LOG.debug("SearchProvider->onToggleCollapse: called with search result: '{}'", (Object)searchResult);
    }

    public void addVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        LOG.debug("SearchProvider->addVertexHopCriteria: called with search result: '{}'", (Object)searchResult);
        VertexHopGraphProvider.VertexHopCriteria criterion = LinkdHopCriteriaFactory.createCriteria(searchResult.getId(), searchResult.getLabel());
        container.addCriteria((Criteria)criterion);
        LOG.debug("SearchProvider->addVertexHop: adding hop criteria {}.", (Object)criterion);
        this.logCriteriaInContainer(container);
    }

    private void logCriteriaInContainer(GraphContainer container) {
        Criteria[] criteria = container.getCriteria();
        LOG.debug("SearchProvider->addVertexHopCriteria: there are now {} criteria in the GraphContainer.", (Object)criteria.length);
        for (Criteria crit : criteria) {
            LOG.debug("SearchProvider->addVertexHopCriteria: criterion: '{}' is in the GraphContainer.", (Object)crit);
        }
    }

    public VertexHopGraphProvider.VertexHopCriteria getDefaultCriteria() {
        Vertex defaultVertex;
        LOG.debug("SearchProvider->getDefaultCriteria called.");
        OnmsNode node = this.m_topologyDao.getDefaultFocusPoint();
        VertexHopGraphProvider.VertexHopCriteria criterion = null;
        if (node != null && (defaultVertex = this.getVertex(TOPOLOGY_NAMESPACE_LINKD, node.getNodeId())) != null) {
            VertexHopGraphProvider.FocusNodeHopCriteria hopCriteria = new VertexHopGraphProvider.FocusNodeHopCriteria();
            hopCriteria.add((VertexRef)defaultVertex);
            return hopCriteria;
        }
        LOG.debug("SearchProvider->getDefaultCriteria:returning hop criteria: '{}'.", criterion);
        return criterion;
    }

    private static String getIfStatusString(int ifStatusNum) {
        if (ifStatusNum < OPER_ADMIN_STATUS.length) {
            return OPER_ADMIN_STATUS[ifStatusNum];
        }
        return "Unknown (" + ifStatusNum + ")";
    }

    private static String getNodeStatusString(OnmsNode.NodeType c) {
        return m_nodeStatusMap.get(c);
    }

    private static String getHumanReadableIfSpeed(long ifSpeed) {
        String units;
        double displaySpeed;
        DecimalFormat formatter;
        if (ifSpeed >= 1000000000L) {
            formatter = ifSpeed % 1000000000L == 0L ? s_noDigitsAfterDecimal : s_oneDigitAfterDecimal;
            displaySpeed = (double)ifSpeed / 1.0E9;
            units = "Gbps";
        } else if (ifSpeed >= 1000000L) {
            formatter = ifSpeed % 1000000L == 0L ? s_noDigitsAfterDecimal : s_oneDigitAfterDecimal;
            displaySpeed = (double)ifSpeed / 1000000.0;
            units = "Mbps";
        } else if (ifSpeed >= 1000L) {
            formatter = ifSpeed % 1000L == 0L ? s_noDigitsAfterDecimal : s_oneDigitAfterDecimal;
            displaySpeed = (double)ifSpeed / 1000.0;
            units = "kbps";
        } else {
            formatter = s_noDigitsAfterDecimal;
            displaySpeed = ifSpeed;
            units = "bps";
        }
        return formatter.format(displaySpeed) + " " + units;
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    static {
        m_nodeStatusMap.put(OnmsNode.NodeType.ACTIVE, "Active");
        m_nodeStatusMap.put(OnmsNode.NodeType.UNKNOWN, "Unknown");
        m_nodeStatusMap.put(OnmsNode.NodeType.DELETED, "Deleted");
        OPER_ADMIN_STATUS = new String[]{"&nbsp;", "Up", "Down", "Testing", "Unknown", "Dormant", "NotPresent", "LowerLayerDown"};
    }

    private class LinkUnknownState
    extends AbstractLinkState {
        public LinkUnknownState(LinkStateMachine linkStateMachine) {
            super(linkStateMachine);
        }

        @Override
        public void setParentInterfaces(OnmsSnmpInterface sourceInterface, OnmsSnmpInterface targetInterface) {
            if (targetInterface != null && targetInterface.getIfOperStatus() != null && sourceInterface != null) {
                if (sourceInterface.getIfOperStatus() == 1 && targetInterface.getIfOperStatus() == 1) {
                    this.getLinkStateMachine().setState(this.getLinkStateMachine().getUpState());
                } else {
                    this.getLinkStateMachine().setState(this.getLinkStateMachine().getDownState());
                }
            }
        }

        @Override
        public String getLinkStatus() {
            return OPER_ADMIN_STATUS[4];
        }
    }

    private class LinkDownState
    extends AbstractLinkState {
        public LinkDownState(LinkStateMachine linkStateMachine) {
            super(linkStateMachine);
        }

        @Override
        public void setParentInterfaces(OnmsSnmpInterface sourceInterface, OnmsSnmpInterface targetInterface) {
            if (targetInterface != null && targetInterface.getIfOperStatus() != null) {
                if (sourceInterface != null && sourceInterface.getIfOperStatus() == 1 && targetInterface.getIfOperStatus() == 1) {
                    this.getLinkStateMachine().setState(this.getLinkStateMachine().getUpState());
                }
            } else if (sourceInterface == null) {
                this.getLinkStateMachine().setState(this.getLinkStateMachine().getUnknownState());
            }
        }

        @Override
        public String getLinkStatus() {
            return OPER_ADMIN_STATUS[2];
        }
    }

    private class LinkUpState
    extends AbstractLinkState {
        public LinkUpState(LinkStateMachine linkStateMachine) {
            super(linkStateMachine);
        }

        @Override
        public void setParentInterfaces(OnmsSnmpInterface sourceInterface, OnmsSnmpInterface targetInterface) {
            if (sourceInterface != null && sourceInterface.getIfOperStatus() != null && sourceInterface.getIfOperStatus() != 1) {
                this.getLinkStateMachine().setState(this.getLinkStateMachine().getDownState());
            }
            if (targetInterface != null && targetInterface.getIfOperStatus() != null && targetInterface.getIfOperStatus() != 1) {
                this.getLinkStateMachine().setState(this.getLinkStateMachine().getDownState());
            }
            if (sourceInterface == null && targetInterface == null) {
                this.getLinkStateMachine().setState(this.getLinkStateMachine().getUnknownState());
            }
        }

        @Override
        public String getLinkStatus() {
            return OPER_ADMIN_STATUS[1];
        }
    }

    private abstract class AbstractLinkState
    implements LinkState {
        private LinkStateMachine m_linkStateMachine;

        public AbstractLinkState(LinkStateMachine linkStateMachine) {
            this.m_linkStateMachine = linkStateMachine;
        }

        protected LinkStateMachine getLinkStateMachine() {
            return this.m_linkStateMachine;
        }
    }

    private static interface LinkState {
        public void setParentInterfaces(OnmsSnmpInterface var1, OnmsSnmpInterface var2);

        public String getLinkStatus();
    }

    private class LinkStateMachine {
        LinkState m_upState;
        LinkState m_downState;
        LinkState m_unknownState;
        LinkState m_state;

        public LinkStateMachine() {
            this.m_upState = new LinkUpState(this);
            this.m_downState = new LinkDownState(this);
            this.m_unknownState = new LinkUnknownState(this);
            this.m_state = this.m_upState;
        }

        public void setParentInterfaces(OnmsSnmpInterface sourceInterface, OnmsSnmpInterface targetInterface) {
            this.m_state.setParentInterfaces(sourceInterface, targetInterface);
        }

        public String getLinkStatus() {
            return this.m_state.getLinkStatus();
        }

        public LinkState getUpState() {
            return this.m_upState;
        }

        public LinkState getDownState() {
            return this.m_downState;
        }

        public LinkState getUnknownState() {
            return this.m_unknownState;
        }

        public void setState(LinkState state) {
            this.m_state = state;
        }
    }
}

