/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal.operations;

import java.util.List;
import java.util.Map;
import org.opennms.features.topology.api.AbstractCheckedOperation;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.Operation;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdTopologyProvider;
import org.slf4j.LoggerFactory;

public class HideNodesWithoutLinksOperation
extends AbstractCheckedOperation {
    private final LinkdTopologyProvider m_topologyProvider;

    public HideNodesWithoutLinksOperation(LinkdTopologyProvider topologyProvider) {
        this.m_topologyProvider = topologyProvider;
    }

    public Operation.Undoer execute(List<VertexRef> targets, OperationContext operationContext) {
        if (this.enabled(targets, operationContext)) {
            this.execute(operationContext.getGraphContainer());
        }
        return null;
    }

    private void execute(GraphContainer container) {
        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).debug("switched addNodeWithoutLinks to: " + !this.m_topologyProvider.isAddNodeWithoutLink());
        this.m_topologyProvider.setAddNodeWithoutLink(!this.m_topologyProvider.isAddNodeWithoutLink());
        this.m_topologyProvider.refresh();
        container.redoLayout();
    }

    public boolean display(List<VertexRef> targets, OperationContext operationContext) {
        return true;
    }

    protected boolean enabled(GraphContainer container) {
        GraphProvider activeGraphProvider = container.getBaseTopology();
        return this.m_topologyProvider.getVertexNamespace().equals(activeGraphProvider.getVertexNamespace());
    }

    public String getId() {
        return "LinkdTopologyProviderHidesNodesWithoutLinksOperation";
    }

    protected boolean isChecked(GraphContainer container) {
        if (this.enabled(container)) {
            return !this.m_topologyProvider.isAddNodeWithoutLink();
        }
        return false;
    }

    public void applyHistory(GraphContainer container, Map<String, String> settings) {
        if ("true".equals(settings.get(((Object)((Object)this)).getClass().getName()))) {
            if (this.m_topologyProvider.isAddNodeWithoutLink()) {
                this.execute(container);
            }
        } else if (!this.m_topologyProvider.isAddNodeWithoutLink()) {
            this.execute(container);
        }
    }
}

