/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.AbstractTopologyProvider;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.EdgeProvider;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.SimpleLeafVertex;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.api.topo.WrappedEdge;
import org.opennms.features.topology.api.topo.WrappedGraph;
import org.opennms.features.topology.api.topo.WrappedGroup;
import org.opennms.features.topology.api.topo.WrappedLeafVertex;
import org.opennms.features.topology.api.topo.WrappedVertex;
import org.opennms.netmgt.dao.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.SnmpInterfaceDao;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.slf4j.LoggerFactory;

public class LinkdTopologyProvider
extends AbstractTopologyProvider
implements GraphProvider {
    public static final String TOPOLOGY_NAMESPACE_LINKD = "nodes";
    private static final String LINKD_GROUP_ID_PREFIX = "linkdg";
    public static final String GROUP_ICON_KEY = "linkd:group";
    public static final String SERVER_ICON_KEY = "linkd:system";
    private static final String HTML_TOOLTIP_TAG_OPEN = "<p>";
    private static final String HTML_TOOLTIP_TAG_END = "</p>";
    private static final DecimalFormat s_oneDigitAfterDecimal = new DecimalFormat("0.0##");
    private static final DecimalFormat s_noDigitsAfterDecimal = new DecimalFormat("0");
    private static final Map<Character, String> m_nodeStatusMap = new HashMap<Character, String>();
    static final String[] OPER_ADMIN_STATUS;
    private boolean addNodeWithoutLink = false;
    private DataLinkInterfaceDao m_dataLinkInterfaceDao;
    private NodeDao m_nodeDao;
    private SnmpInterfaceDao m_snmpInterfaceDao;
    private IpInterfaceDao m_ipInterfaceDao;
    private String m_configurationFile;

    public String getConfigurationFile() {
        return this.m_configurationFile;
    }

    public void setConfigurationFile(String configurationFile) {
        this.m_configurationFile = configurationFile;
    }

    public SnmpInterfaceDao getSnmpInterfaceDao() {
        return this.m_snmpInterfaceDao;
    }

    public void setSnmpInterfaceDao(SnmpInterfaceDao snmpInterfaceDao) {
        this.m_snmpInterfaceDao = snmpInterfaceDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public boolean isAddNodeWithoutLink() {
        return this.addNodeWithoutLink;
    }

    public void setAddNodeWithoutLink(boolean addNodeWithoutLink) {
        this.addNodeWithoutLink = addNodeWithoutLink;
    }

    public DataLinkInterfaceDao getDataLinkInterfaceDao() {
        return this.m_dataLinkInterfaceDao;
    }

    public void setDataLinkInterfaceDao(DataLinkInterfaceDao dataLinkInterfaceDao) {
        this.m_dataLinkInterfaceDao = dataLinkInterfaceDao;
    }

    public void onInit() throws MalformedURLException, JAXBException {
        LinkdTopologyProvider.log("init: loading topology v1.3");
        this.load(null);
    }

    public LinkdTopologyProvider() {
        super(TOPOLOGY_NAMESPACE_LINKD);
    }

    private static WrappedGraph getGraphFromFile(File file) throws JAXBException, MalformedURLException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{WrappedGraph.class});
        Unmarshaller u = jc.createUnmarshaller();
        return (WrappedGraph)u.unmarshal(file.toURI().toURL());
    }

    public void refresh() {
        try {
            this.load(null);
        }
        catch (MalformedURLException e) {
            LoggerFactory.getLogger(LinkdTopologyProvider.class).error(e.getMessage(), (Throwable)e);
        }
        catch (JAXBException e) {
            LoggerFactory.getLogger(LinkdTopologyProvider.class).error(e.getMessage(), (Throwable)e);
        }
    }

    public void load(String filename) throws MalformedURLException, JAXBException {
        if (filename != null) {
            LoggerFactory.getLogger(LinkdTopologyProvider.class).warn("Filename that was specified for linkd topology will be ignored: " + filename + ", using " + this.m_configurationFile + " instead");
        }
        LinkdTopologyProvider.log("loadtopology: Clear " + VertexProvider.class.getSimpleName());
        this.clearVertices();
        LinkdTopologyProvider.log("loadtopology: Clear " + EdgeProvider.class.getSimpleName());
        this.clearEdges();
        for (DataLinkInterface link : this.m_dataLinkInterfaceDao.findAll()) {
            LinkdTopologyProvider.log("loadtopology: parsing link: " + link.getDataLinkInterfaceId());
            OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)link.getNode().getId());
            LinkdTopologyProvider.log("loadtopology: found source node: " + node.getLabel());
            String sourceId = node.getNodeId();
            Vertex source = this.getVertex(this.getVertexNamespace(), sourceId);
            if (source == null) {
                LinkdTopologyProvider.log("loadtopology: adding source node as vertex: " + node.getLabel());
                source = this.getVertex(node);
                this.addVertices(new Vertex[]{source});
            }
            OnmsNode parentNode = (OnmsNode)this.m_nodeDao.get((Serializable)link.getNodeParentId());
            LinkdTopologyProvider.log("loadtopology: found target node: " + parentNode.getLabel());
            String targetId = parentNode.getNodeId();
            Vertex target = this.getVertex(this.getVertexNamespace(), targetId);
            if (target == null) {
                LinkdTopologyProvider.log("loadtopology: adding target as vertex: " + parentNode.getLabel());
                target = this.getVertex(parentNode);
                this.addVertices(new Vertex[]{target});
            }
            AbstractEdge edge = this.connectVertices(link.getDataLinkInterfaceId(), (VertexRef)source, (VertexRef)target);
            edge.setTooltipText(this.getEdgeTooltipText(link, source, target));
        }
        LinkdTopologyProvider.log("loadtopology: adding nodes without links: " + this.isAddNodeWithoutLink());
        if (this.isAddNodeWithoutLink()) {
            for (OnmsNode onmsnode : this.m_nodeDao.findAll()) {
                String nodeId = onmsnode.getNodeId();
                if (this.getVertex(this.getVertexNamespace(), nodeId) != null) continue;
                LinkdTopologyProvider.log("loadtopology: adding link-less node: " + onmsnode.getLabel());
                this.addVertices(new Vertex[]{this.getVertex(onmsnode)});
            }
        }
        LinkdTopologyProvider.log("Found " + this.getVertices().size() + " vertices");
        LinkdTopologyProvider.log("Found " + this.getEdges().size() + " edges");
        File configFile = new File(this.m_configurationFile);
        if (configFile.exists() && configFile.canRead()) {
            LinkdTopologyProvider.log("loadtopology: loading topology from configuration file: " + this.m_configurationFile);
            this.m_groupCounter = 0;
            WrappedGraph graph = LinkdTopologyProvider.getGraphFromFile(configFile);
            int numberOfGroups = 0;
            for (WrappedVertex vertex : graph.m_vertices) {
                if (!vertex.group) continue;
                LinkdTopologyProvider.log("loadtopology: adding group to topology: " + vertex.id);
                if (vertex.namespace == null) {
                    vertex.namespace = this.getVertexNamespace();
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Setting namespace on vertex to default: {}", (Object)vertex);
                }
                if (vertex.id == null) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Invalid vertex unmarshalled from {}: {}", (Object)this.m_configurationFile, (Object)vertex);
                } else if (vertex.id.startsWith(LINKD_GROUP_ID_PREFIX)) {
                    try {
                        int groupNumber = Integer.parseInt(vertex.id.substring(LINKD_GROUP_ID_PREFIX.length()));
                        if (this.m_groupCounter <= groupNumber) {
                            this.m_groupCounter = groupNumber + 1;
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                AbstractVertex newVertex = this.addGroup(vertex.id, vertex.iconKey, vertex.label);
                newVertex.setIpAddress(vertex.ipAddr);
                newVertex.setLocked(vertex.locked);
                if (vertex.nodeID != null) {
                    newVertex.setNodeID(vertex.nodeID);
                }
                newVertex.setParent((VertexRef)vertex.parent);
                newVertex.setSelected(vertex.selected);
                newVertex.setStyleName(vertex.styleName);
                newVertex.setTooltipText(vertex.tooltipText);
                if (vertex.x != null) {
                    newVertex.setX(vertex.x);
                }
                if (vertex.y != null) {
                    newVertex.setY(vertex.y);
                }
                ++numberOfGroups;
            }
            for (WrappedVertex vertex : this.getVertices()) {
                if (vertex.getParent() == null) continue;
                LinkdTopologyProvider.log("loadtopology: setting parent of " + vertex + " to " + vertex.getParent());
                this.setParent((VertexRef)vertex, vertex.getParent());
            }
            LinkdTopologyProvider.log("Found " + numberOfGroups + " groups");
        } else {
            LinkdTopologyProvider.log("loadtopology: could not load topology configFile:" + this.m_configurationFile);
        }
    }

    private AbstractVertex getVertex(OnmsNode onmsnode) {
        OnmsIpInterface ip = this.getAddress(onmsnode);
        SimpleLeafVertex vertex = new SimpleLeafVertex(TOPOLOGY_NAMESPACE_LINKD, onmsnode.getNodeId(), Integer.valueOf(0), Integer.valueOf(0));
        vertex.setIconKey(LinkdTopologyProvider.getIconName(onmsnode));
        vertex.setLabel(onmsnode.getLabel());
        vertex.setIpAddress(ip == null ? null : ip.getIpAddress().getHostAddress());
        vertex.setNodeID(Integer.valueOf(Integer.parseInt(onmsnode.getNodeId())));
        vertex.setTooltipText(LinkdTopologyProvider.getNodeTooltipText(onmsnode, (AbstractVertex)vertex, ip));
        return vertex;
    }

    private OnmsIpInterface getAddress(OnmsNode node) {
        OnmsIpInterface ip;
        block0: {
            OnmsIpInterface iterip;
            Iterator i$;
            ip = this.m_ipInterfaceDao.findPrimaryInterfaceByNodeId(node.getId());
            if (ip != null || !(i$ = this.m_ipInterfaceDao.findByNodeId(node.getId()).iterator()).hasNext()) break block0;
            ip = iterip = (OnmsIpInterface)i$.next();
        }
        return ip;
    }

    private String getEdgeTooltipText(DataLinkInterface link, Vertex source, Vertex target) {
        StringBuffer tooltipText = new StringBuffer();
        OnmsSnmpInterface sourceInterface = this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(Integer.parseInt(source.getId())), link.getIfIndex());
        OnmsSnmpInterface targetInterface = this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(Integer.parseInt(target.getId())), link.getParentIfIndex());
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        if (sourceInterface != null && targetInterface != null && sourceInterface.getNetMask() != null && !sourceInterface.getNetMask().isLoopbackAddress() && targetInterface.getNetMask() != null && !targetInterface.getNetMask().isLoopbackAddress()) {
            tooltipText.append("Type of Link: Layer3/Layer2");
        } else {
            tooltipText.append("Type of Link: Layer2");
        }
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append("Name: &lt;endpoint1 " + source.getLabel());
        if (sourceInterface != null) {
            tooltipText.append(":" + sourceInterface.getIfName());
        }
        tooltipText.append(" ---- endpoint2 " + target.getLabel());
        if (targetInterface != null) {
            tooltipText.append(":" + targetInterface.getIfName());
        }
        tooltipText.append("&gt;");
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        if (targetInterface != null) {
            if (targetInterface.getIfSpeed() != null) {
                tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
                tooltipText.append("Bandwidth: " + LinkdTopologyProvider.getHumanReadableIfSpeed(targetInterface.getIfSpeed()));
                tooltipText.append(HTML_TOOLTIP_TAG_END);
            }
            if (targetInterface.getIfOperStatus() != null) {
                tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
                tooltipText.append("Link status: " + LinkdTopologyProvider.getIfStatusString(targetInterface.getIfOperStatus()));
                tooltipText.append(HTML_TOOLTIP_TAG_END);
            }
        } else if (sourceInterface != null) {
            if (sourceInterface.getIfSpeed() != null) {
                tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
                tooltipText.append("Bandwidth: " + LinkdTopologyProvider.getHumanReadableIfSpeed(sourceInterface.getIfSpeed()));
                tooltipText.append(HTML_TOOLTIP_TAG_END);
            }
            if (sourceInterface.getIfOperStatus() != null) {
                tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
                tooltipText.append("Link status: " + LinkdTopologyProvider.getIfStatusString(sourceInterface.getIfOperStatus()));
                tooltipText.append(HTML_TOOLTIP_TAG_END);
            }
        }
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append("End Point 1: " + source.getLabel() + ", " + source.getIpAddress());
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append("End Point 2: " + target.getLabel() + ", " + target.getIpAddress());
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        LinkdTopologyProvider.log("getEdgeTooltipText\n" + tooltipText);
        return tooltipText.toString();
    }

    private static String getNodeTooltipText(OnmsNode node, AbstractVertex vertex, OnmsIpInterface ip) {
        StringBuffer tooltipText = new StringBuffer();
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append("Management IP and Name: " + vertex.getIpAddress() + " (" + vertex.getLabel() + ")");
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        if (node.getSysLocation() != null && node.getSysLocation().length() > 0) {
            tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
            tooltipText.append("Location: " + node.getSysLocation());
            tooltipText.append(HTML_TOOLTIP_TAG_END);
        }
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append("Status: " + LinkdTopologyProvider.getNodeStatusString(node.getType().charAt(0)));
        if (ip != null && ip.isManaged()) {
            tooltipText.append(" / Managed");
        } else {
            tooltipText.append(" / Unmanaged");
        }
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        LinkdTopologyProvider.log("getNodeTooltipText:\n" + tooltipText);
        return tooltipText.toString();
    }

    public static String getIconName(OnmsNode node) {
        return node.getSysObjectId() == null ? SERVER_ICON_KEY : "linkd:system:snmp:" + node.getSysObjectId();
    }

    public void save() {
        ArrayList<Object> vertices = new ArrayList<Object>();
        for (Vertex vertex : this.getVertices()) {
            if (vertex.isGroup()) {
                vertices.add(new WrappedGroup(vertex));
                continue;
            }
            vertices.add(new WrappedLeafVertex(vertex));
        }
        ArrayList<WrappedEdge> edges = new ArrayList<WrappedEdge>();
        for (Edge edge : this.getEdges()) {
            WrappedEdge newEdge = new WrappedEdge(edge, (WrappedVertex)new WrappedLeafVertex(this.m_vertexProvider.getVertex(edge.getSource().getVertex())), (WrappedVertex)new WrappedLeafVertex(this.m_vertexProvider.getVertex(edge.getTarget().getVertex())));
            edges.add(newEdge);
        }
        WrappedGraph graph = new WrappedGraph(this.getEdgeNamespace(), vertices, edges);
        JAXB.marshal((Object)graph, (File)new File(this.m_configurationFile));
    }

    private static String getIfStatusString(int ifStatusNum) {
        if (ifStatusNum < OPER_ADMIN_STATUS.length) {
            return OPER_ADMIN_STATUS[ifStatusNum];
        }
        return "Unknown (" + ifStatusNum + ")";
    }

    private static String getNodeStatusString(char c) {
        return m_nodeStatusMap.get(Character.valueOf(c));
    }

    private static String getHumanReadableIfSpeed(long ifSpeed) {
        String units;
        double displaySpeed;
        DecimalFormat formatter;
        if (ifSpeed >= 1000000000L) {
            formatter = ifSpeed % 1000000000L == 0L ? s_noDigitsAfterDecimal : s_oneDigitAfterDecimal;
            displaySpeed = (double)ifSpeed / 1.0E9;
            units = "Gbps";
        } else if (ifSpeed >= 1000000L) {
            formatter = ifSpeed % 1000000L == 0L ? s_noDigitsAfterDecimal : s_oneDigitAfterDecimal;
            displaySpeed = (double)ifSpeed / 1000000.0;
            units = "Mbps";
        } else if (ifSpeed >= 1000L) {
            formatter = ifSpeed % 1000L == 0L ? s_noDigitsAfterDecimal : s_oneDigitAfterDecimal;
            displaySpeed = (double)ifSpeed / 1000.0;
            units = "kbps";
        } else {
            formatter = s_noDigitsAfterDecimal;
            displaySpeed = ifSpeed;
            units = "bps";
        }
        return formatter.format(displaySpeed) + " " + units;
    }

    private static void log(String string) {
        LoggerFactory.getLogger(LinkdTopologyProvider.class).debug(string);
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    static {
        m_nodeStatusMap.put(Character.valueOf('A'), "Active");
        m_nodeStatusMap.put(Character.valueOf(' '), "Unknown");
        m_nodeStatusMap.put(Character.valueOf('D'), "Deleted");
        OPER_ADMIN_STATUS = new String[]{"&nbsp;", "Up", "Down", "Testing", "Unknown", "Dormant", "NotPresent", "LowerLayerDown"};
    }
}

