/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.graphml;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import javax.xml.bind.JAXB;
import org.graphdrawing.graphml.GraphmlType;
import org.opennms.features.graphml.service.GraphmlRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphmlRepositoryImpl
implements GraphmlRepository {
    protected static final String CFG_FILE_PREFIX = "org.opennms.features.topology.plugins.topo.graphml";
    protected static final String TOPOLOGY_LOCATION = "topologyLocation";
    protected static final String LABEL = "label";
    private static final Logger LOG = LoggerFactory.getLogger(GraphmlRepositoryImpl.class);

    public GraphmlRepositoryImpl() {
        Preconditions.checkState((System.getProperty("opennms.home") != null ? 1 : 0) != 0, (Object)"No opennms.home defined. Bailing out...");
    }

    public GraphmlType findByName(String name) throws IOException {
        Objects.requireNonNull(name);
        if (!this.exists(name)) {
            throw new NoSuchElementException("No GraphML file found with name  " + name);
        }
        GraphmlType graphmlType = (GraphmlType)JAXB.unmarshal((File)new File(GraphmlRepositoryImpl.buildGraphmlFilepath(name)), GraphmlType.class);
        return graphmlType;
    }

    public void save(String name, String label, GraphmlType graphmlType) throws IOException {
        LOG.debug("Saving GraphML file {}\u00a0with label", (Object)name, (Object)label);
        Objects.requireNonNull(name);
        Objects.requireNonNull(label);
        Objects.requireNonNull(graphmlType);
        if (this.exists(name)) {
            LOG.warn("GraphML file with name {} already exists", (Object)name);
            throw new IOException(name + " already exists");
        }
        File graphFile = new File(GraphmlRepositoryImpl.buildGraphmlFilepath(name));
        File cfgFile = new File(GraphmlRepositoryImpl.buildCfgFilepath(name));
        LOG.debug("GraphML xml location: {}", (Object)graphFile);
        LOG.debug("GraphML cfg location: {}", (Object)cfgFile);
        graphFile.getParentFile().mkdirs();
        cfgFile.getParentFile().mkdirs();
        JAXB.marshal((Object)graphmlType, (File)graphFile);
        Properties properties = new Properties();
        properties.put(TOPOLOGY_LOCATION, graphFile.toString());
        properties.put(LABEL, label);
        properties.store(new FileWriter(cfgFile), "Generated by " + this.getClass().getSimpleName() + ". DO NOT EDIT!");
    }

    public void delete(String name) throws IOException {
        LOG.debug("Delete GraphML file with name {}", (Object)name);
        Objects.requireNonNull(name);
        this.findByName(name);
        Files.delete(Paths.get(GraphmlRepositoryImpl.buildCfgFilepath(name), new String[0]));
        Files.delete(Paths.get(GraphmlRepositoryImpl.buildGraphmlFilepath(name), new String[0]));
    }

    public boolean exists(String name) {
        String filename = GraphmlRepositoryImpl.buildGraphmlFilepath(name);
        return new File(filename).exists() && new File(filename).isFile();
    }

    protected static String buildCfgFilepath(String filename) {
        return Paths.get(System.getProperty("opennms.home"), "etc", "org.opennms.features.topology.plugins.topo.graphml-" + filename + ".cfg").toString();
    }

    protected static String buildGraphmlFilepath(String filename) {
        return Paths.get(System.getProperty("opennms.home"), "etc", "graphml", filename + ".xml").toString();
    }
}

