/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.graphml;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.netmgt.model.OnmsSeverity;

public class GraphMLEdgeStatus
implements Status {
    public static final Set<String> ALLOWED_PROPERTIES = ImmutableSet.of((Object)"stroke", (Object)"stroke-width", (Object)"stroke-dasharray");
    private static final Map<String, String> EMPTY_PROPERTIES = Maps.asMap(ALLOWED_PROPERTIES, key -> null);
    private OnmsSeverity severity;
    private Map<String, String> styleProperties;

    private GraphMLEdgeStatus(OnmsSeverity severity, Map<String, String> styleProperties) {
        GraphMLEdgeStatus.checkPropertyNames(styleProperties);
        this.severity = severity;
        this.styleProperties = styleProperties;
    }

    public GraphMLEdgeStatus() {
        this(OnmsSeverity.INDETERMINATE, Maps.newHashMap(EMPTY_PROPERTIES));
    }

    public OnmsSeverity getSeverity() {
        return this.severity;
    }

    public String computeStatus() {
        return this.severity.getLabel().toLowerCase();
    }

    public Map<String, String> getStatusProperties() {
        return ImmutableMap.of((Object)"status", (Object)this.computeStatus());
    }

    public Map<String, String> getStyleProperties() {
        return this.styleProperties;
    }

    public GraphMLEdgeStatus severity(OnmsSeverity severity) {
        this.severity = severity;
        return this;
    }

    public GraphMLEdgeStatus style(Map<String, String> style) {
        GraphMLEdgeStatus.checkPropertyNames(style);
        this.styleProperties.putAll(style);
        return this;
    }

    public GraphMLEdgeStatus style(String key, String value) {
        GraphMLEdgeStatus.checkPropertyName(key);
        this.styleProperties.put(key, value);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphMLEdgeStatus that = (GraphMLEdgeStatus)o;
        return Objects.equal((Object)this.severity, (Object)that.severity) && Objects.equal(this.styleProperties, that.styleProperties);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.severity, this.styleProperties});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("severity", (Object)this.severity).add("styleProperties", this.styleProperties).toString();
    }

    private static void checkPropertyNames(Map<String, String> styleProperties) {
        for (String key : styleProperties.keySet()) {
            GraphMLEdgeStatus.checkPropertyName(key);
        }
    }

    private static void checkPropertyName(String key) {
        Preconditions.checkArgument((boolean)ALLOWED_PROPERTIES.contains(key), (String)"Illegal property name: %s - allowed properties are: %s", (Object[])new Object[]{key, Joiner.on((String)", ").join(ALLOWED_PROPERTIES)});
    }

    public static GraphMLEdgeStatus merge(GraphMLEdgeStatus s1, GraphMLEdgeStatus s2) {
        OnmsSeverity severity = s1.getSeverity().isGreaterThan(s2.getSeverity()) ? s1.getSeverity() : s2.getSeverity();
        HashMap styleProperties = Maps.newHashMap(EMPTY_PROPERTIES);
        for (Map.Entry<String, String> e : s1.styleProperties.entrySet()) {
            if (e.getValue() == null) continue;
            styleProperties.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String, String> e : s2.styleProperties.entrySet()) {
            if (e.getValue() == null) continue;
            styleProperties.put(e.getKey(), e.getValue());
        }
        return new GraphMLEdgeStatus(severity, styleProperties);
    }
}

