/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.graphml;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultStatus;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.features.topology.api.topo.StatusProvider;
import org.opennms.features.topology.api.topo.VertexProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.graphml.GraphMLVertex;
import org.opennms.features.topology.plugins.topo.graphml.internal.AlarmSummaryWrapper;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.alarm.AlarmSummary;

public class GraphMLVertexStatusProvider
implements StatusProvider {
    private final String namespace;
    private final AlarmSummaryWrapper alarmSummaryWrapper;

    public GraphMLVertexStatusProvider(String namespace, AlarmSummaryWrapper alarmSummaryWrapper) {
        this.namespace = Objects.requireNonNull(namespace);
        this.alarmSummaryWrapper = Objects.requireNonNull(alarmSummaryWrapper);
    }

    public boolean contributesTo(String namespace) {
        return this.getNamespace().equals(namespace);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<VertexRef, Status> getStatusForVertices(VertexProvider vertexProvider, Collection<VertexRef> vertices, Criteria[] criteria) {
        List graphMLVertices = vertices.stream().filter(eachVertex -> this.contributesTo(eachVertex.getNamespace()) && eachVertex instanceof GraphMLVertex).map(eachVertex -> (GraphMLVertex)((Object)eachVertex)).collect(Collectors.toList());
        Map nodeIdMap = graphMLVertices.stream().filter(eachVertex -> eachVertex.getNodeID() != null).collect(Collectors.toMap(AbstractVertex::getNodeID, Function.identity()));
        Map<Integer, AlarmSummary> nodeIdToAlarmSummaryMap = this.getAlarmSummaries(nodeIdMap.keySet());
        HashMap resultMap = Maps.newHashMap();
        for (GraphMLVertex eachVertex2 : graphMLVertices) {
            AlarmSummary alarmSummary = nodeIdToAlarmSummaryMap.get(eachVertex2.getNodeID());
            VertexStatus status = alarmSummary == null ? new VertexStatus(OnmsSeverity.NORMAL) : new VertexStatus(alarmSummary.getMaxSeverity(), alarmSummary.getAlarmCount());
            resultMap.put(eachVertex2, status);
        }
        return resultMap;
    }

    private Map<Integer, AlarmSummary> getAlarmSummaries(Set<Integer> nodeIds) {
        return this.alarmSummaryWrapper.getAlarmSummaries(new ArrayList<Integer>(nodeIds)).stream().collect(Collectors.toMap(AlarmSummary::getNodeId, Function.identity()));
    }

    protected static class VertexStatus
    extends DefaultStatus {
        public VertexStatus(OnmsSeverity severity, long count) {
            super(severity.getLabel(), count);
        }

        public VertexStatus(OnmsSeverity severity) {
            this(severity, 0L);
        }
    }
}

