/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm.simulate;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.plugins.topo.bsm.simulate.InheritStateCriteria;
import org.opennms.features.topology.plugins.topo.bsm.simulate.SetStatusToCriteria;
import org.opennms.features.topology.plugins.topo.bsm.simulate.SimulationEnabledCriteria;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.BusinessServiceStateMachine;
import org.opennms.netmgt.bsm.service.model.AlarmWrapper;
import org.opennms.netmgt.bsm.service.model.Status;

public class SimulationAwareStateMachineFactory {
    private SimulationAwareStateMachineFactory() {
    }

    public static boolean isInSimulationMode(Criteria[] criteria) {
        return Arrays.stream(criteria).anyMatch(c -> c instanceof SimulationEnabledCriteria);
    }

    public static BusinessServiceStateMachine createStateMachine(BusinessServiceManager manager, Criteria[] criteria) {
        if (SimulationAwareStateMachineFactory.isInSimulationMode(criteria)) {
            return SimulationAwareStateMachineFactory.createSimulatedStateMachine(manager, criteria);
        }
        return manager.getStateMachine();
    }

    public static BusinessServiceStateMachine createSimulatedStateMachine(BusinessServiceManager manager, Criteria[] criteria) {
        Map<String, Status> statusByReductionKey = Arrays.stream(criteria).filter(c -> c instanceof SetStatusToCriteria).map(c -> (SetStatusToCriteria)((Object)c)).filter(c -> c.getStatus() != null).collect(Collectors.toMap(SetStatusToCriteria::getReductionKey, SetStatusToCriteria::getStatus));
        boolean shouldInheritState = Arrays.stream(criteria).anyMatch(c -> c instanceof InheritStateCriteria);
        BusinessServiceStateMachine stateMachine = manager.getStateMachine().clone(shouldInheritState);
        for (final Map.Entry<String, Status> entry : statusByReductionKey.entrySet()) {
            stateMachine.handleNewOrUpdatedAlarm(new AlarmWrapper(){

                public String getReductionKey() {
                    return (String)entry.getKey();
                }

                public Status getStatus() {
                    return (Status)entry.getValue();
                }

                public Integer getId() {
                    return 0;
                }
            });
        }
        return stateMachine;
    }
}

