/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm.operations;

import java.util.Collection;
import java.util.Collections;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertexVisitor;
import org.opennms.features.topology.plugins.topo.bsm.IpServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.ReductionKeyVertex;
import org.opennms.features.topology.plugins.topo.bsm.operations.AbstractAnalysisOperation;
import org.opennms.netmgt.bsm.service.BusinessServiceStateMachine;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;

public class RootCauseAnalysisOperation
extends AbstractAnalysisOperation {
    @Override
    public BusinessServiceVertexVisitor<Boolean> getVisitorForSupportedVertices() {
        return new BusinessServiceVertexVisitor<Boolean>(){

            @Override
            public Boolean visit(BusinessServiceVertex vertex) {
                return true;
            }

            @Override
            public Boolean visit(IpServiceVertex vertex) {
                return false;
            }

            @Override
            public Boolean visit(ReductionKeyVertex vertex) {
                return false;
            }
        };
    }

    @Override
    public BusinessServiceVertexVisitor<Collection<GraphVertex>> getVisitorForVerticesToFocus(final BusinessServiceStateMachine stateMachine) {
        return new BusinessServiceVertexVisitor<Collection<GraphVertex>>(){

            @Override
            public Collection<GraphVertex> visit(BusinessServiceVertex vertex) {
                BusinessService businessService = RootCauseAnalysisOperation.this.getBusinessServiceManager().getBusinessServiceById(vertex.getServiceId());
                return stateMachine.calculateRootCause(businessService);
            }

            @Override
            public Collection<GraphVertex> visit(IpServiceVertex vertex) {
                return Collections.emptyList();
            }

            @Override
            public Collection<GraphVertex> visit(ReductionKeyVertex vertex) {
                return Collections.emptyList();
            }
        };
    }

    @Override
    public String getMessageForNoResultDialog() {
        return "No root cause was found for the selected vertices.";
    }

    public String getId() {
        return this.getClass().getCanonicalName();
    }
}

