/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm.info;

import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.info.VertexInfoPanelItem;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServicesStatusProvider;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServicesTopologyProvider;
import org.opennms.features.topology.plugins.topo.bsm.IpServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.ReductionKeyVertex;
import org.opennms.features.topology.plugins.topo.bsm.simulate.SimulationAwareStateMachineFactory;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.BusinessServiceStateMachine;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.edge.ChildEdge;
import org.opennms.netmgt.bsm.service.model.edge.Edge;
import org.opennms.netmgt.bsm.service.model.edge.EdgeVisitor;
import org.opennms.netmgt.bsm.service.model.edge.IpServiceEdge;
import org.opennms.netmgt.bsm.service.model.edge.ReductionKeyEdge;
import org.opennms.netmgt.bsm.service.model.graph.BusinessServiceGraph;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;
import org.opennms.netmgt.vaadin.core.TransactionAwareBeanProxyFactory;
import org.opennms.netmgt.vaadin.core.UIHelper;

public class BusinessServiceVertexStatusInfoPanelItem
extends VertexInfoPanelItem {
    private BusinessServiceManager businessServiceManager;
    private BusinessServicesTopologyProvider businessServicesTopologyProvider;
    private final TransactionAwareBeanProxyFactory transactionAwareBeanProxyFactory;

    public BusinessServiceVertexStatusInfoPanelItem(TransactionAwareBeanProxyFactory transactionAwareBeanProxyFactory) {
        this.transactionAwareBeanProxyFactory = transactionAwareBeanProxyFactory;
    }

    public void setBusinessServiceManager(BusinessServiceManager businessServiceManager) {
        this.businessServiceManager = (BusinessServiceManager)this.transactionAwareBeanProxyFactory.createProxy((Object)businessServiceManager);
    }

    public void setBusinessServicesTopologyProvider(BusinessServicesTopologyProvider businessServicesTopologyProvider) {
        this.businessServicesTopologyProvider = businessServicesTopologyProvider;
    }

    protected boolean contributesTo(VertexRef vertexRef, GraphContainer container) {
        return vertexRef instanceof BusinessServiceVertex;
    }

    protected Component getComponent(VertexRef ref, GraphContainer container) {
        BusinessServiceVertex vertex = (BusinessServiceVertex)ref;
        FormLayout rootLayout = new FormLayout();
        rootLayout.setSizeFull();
        rootLayout.setSpacing(false);
        rootLayout.setMargin(false);
        rootLayout.addStyleName("severity");
        BusinessServiceStateMachine stateMachine = SimulationAwareStateMachineFactory.createStateMachine(this.businessServiceManager, container.getCriteria());
        Status overallStatus = BusinessServicesStatusProvider.getStatus(stateMachine, vertex);
        rootLayout.addComponent((Component)BusinessServiceVertexStatusInfoPanelItem.createStatusLabel("Overall", overallStatus));
        rootLayout.addComponent((Component)new Label());
        BusinessServiceGraph graph = stateMachine.getGraph();
        BusinessService businessService = this.businessServiceManager.getBusinessServiceById(vertex.getServiceId());
        Set impactingVertices = stateMachine.calculateImpacting(businessService).stream().map(e -> (GraphVertex)graph.getDest(e)).collect(Collectors.toSet());
        for (Edge edge : businessService.getEdges()) {
            Vertex childVertex = this.businessServicesTopologyProvider.getVertex((VertexRef)edge.accept((EdgeVisitor)new EdgeVisitor<VertexRef>(){

                public VertexRef visit(IpServiceEdge edge) {
                    return new IpServiceVertex(edge.getIpService(), 0);
                }

                public VertexRef visit(ReductionKeyEdge edge) {
                    return new ReductionKeyVertex(edge.getReductionKey(), 0);
                }

                public VertexRef visit(ChildEdge edge) {
                    return new BusinessServiceVertex(edge.getChild(), 0);
                }
            }), new Criteria[0]);
            Status edgeStatus = stateMachine.getOperationalStatus(edge);
            rootLayout.addComponent((Component)BusinessServiceVertexStatusInfoPanelItem.createStatusLabel(childVertex.getLabel(), edgeStatus, String.format("%s &times; %d <i class=\"pull-right glyphicon %s\"></i>", edgeStatus.getLabel(), edge.getWeight(), impactingVertices.contains(graph.getVertexByEdgeId(edge.getId())) ? "glyphicon-flash" : "")));
        }
        return rootLayout;
    }

    protected String getTitle(VertexRef ref) {
        return "Business Service Status";
    }

    public int getOrder() {
        return 100;
    }

    public static Label createStatusLabel(String caption, Status status) {
        return BusinessServiceVertexStatusInfoPanelItem.createStatusLabel(caption, status, status.getLabel());
    }

    public static Label createStatusLabel(String caption, Status status, String text) {
        Label label = UIHelper.createLabel((String)caption, (String)text);
        label.setContentMode(ContentMode.HTML);
        label.addStyleName("severity-" + status.toString().toLowerCase());
        label.addStyleName("bright");
        return label;
    }
}

