/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm.info;

import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.info.EdgeInfoPanelItem;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.plugins.topo.bsm.AbstractBusinessServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceEdge;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServicesStatusProvider;
import org.opennms.features.topology.plugins.topo.bsm.info.BusinessServiceVertexStatusInfoPanelItem;
import org.opennms.features.topology.plugins.topo.bsm.simulate.SimulationAwareStateMachineFactory;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.BusinessServiceStateMachine;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.vaadin.core.TransactionAwareBeanProxyFactory;

public class BusinessServiceEdgeStatusInfoPanelItem
extends EdgeInfoPanelItem {
    private BusinessServiceManager businessServiceManager;
    private final TransactionAwareBeanProxyFactory transactionAwareBeanProxyFactory;

    public BusinessServiceEdgeStatusInfoPanelItem(TransactionAwareBeanProxyFactory transactionAwareBeanProxyFactory) {
        this.transactionAwareBeanProxyFactory = transactionAwareBeanProxyFactory;
    }

    public void setBusinessServiceManager(BusinessServiceManager businessServiceManager) {
        this.businessServiceManager = (BusinessServiceManager)this.transactionAwareBeanProxyFactory.createProxy((Object)businessServiceManager);
    }

    protected Component getComponent(EdgeRef ref, GraphContainer container) {
        FormLayout formLayout = new FormLayout();
        formLayout.setMargin(false);
        formLayout.setSpacing(false);
        formLayout.addStyleName("severity");
        BusinessServiceEdge businessServiceEdge = (BusinessServiceEdge)ref;
        BusinessServiceStateMachine stateMachine = SimulationAwareStateMachineFactory.createStateMachine(this.businessServiceManager, container.getCriteria());
        Status outgoingStatus = BusinessServicesStatusProvider.getStatus(stateMachine, businessServiceEdge);
        Status incomingStatus = BusinessServicesStatusProvider.getStatus(stateMachine, (AbstractBusinessServiceVertex)businessServiceEdge.getTarget().getVertex());
        formLayout.addComponent((Component)BusinessServiceVertexStatusInfoPanelItem.createStatusLabel("Outgoing Severity", outgoingStatus));
        formLayout.addComponent((Component)BusinessServiceVertexStatusInfoPanelItem.createStatusLabel("Incoming Severity", incomingStatus));
        return formLayout;
    }

    protected boolean contributesTo(EdgeRef edgeRef, GraphContainer container) {
        return "bsm".equals(edgeRef.getNamespace());
    }

    public int getOrder() {
        return 0;
    }

    protected String getTitle(EdgeRef edgeRef) {
        return "Map Function Status";
    }
}

