/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.support.VertexHopGraphProvider;
import org.opennms.features.topology.api.topo.AbstractSearchProvider;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.SearchProvider;
import org.opennms.features.topology.api.topo.SearchQuery;
import org.opennms.features.topology.api.topo.SearchResult;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertex;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessServiceSearchProvider
extends AbstractSearchProvider
implements SearchProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BusinessServiceSearchProvider.class);
    private BusinessServiceManager businessServiceManager;

    public String getSearchProviderNamespace() {
        return "bsm";
    }

    public boolean contributesTo(String namespace) {
        return "bsm".equalsIgnoreCase(namespace);
    }

    public boolean supportsPrefix(String searchPrefix) {
        return BusinessServiceSearchProvider.supportsPrefix((String)"bsm=", (String)searchPrefix);
    }

    public List<SearchResult> query(SearchQuery searchQuery, GraphContainer container) {
        LOG.info("BusinessServiceSearchProvider->query: called with search query: '{}'", (Object)searchQuery);
        ArrayList results = Lists.newArrayList();
        String queryString = searchQuery.getQueryString();
        CriteriaBuilder bldr = new CriteriaBuilder(BusinessService.class);
        if (queryString != null && queryString.length() > 0) {
            bldr.ilike("name", (Object)String.format("%%%s%%", queryString));
        }
        bldr.orderBy("name", true);
        bldr.limit(Integer.valueOf(10));
        Criteria dbQueryCriteria = bldr.toCriteria();
        for (BusinessService bs : this.businessServiceManager.findMatching(dbQueryCriteria)) {
            BusinessServiceVertex businessServiceVertex = new BusinessServiceVertex(bs, 0);
            if (container.getBaseTopology().getVertex((VertexRef)businessServiceVertex, new org.opennms.features.topology.api.topo.Criteria[0]) == null) continue;
            SearchResult searchResult = new SearchResult((VertexRef)businessServiceVertex);
            searchResult.setCollapsed(false);
            searchResult.setCollapsible(true);
            results.add(searchResult);
        }
        LOG.info("BusinessServiceSearchProvider->query: found {} results: {}", (Object)results.size(), (Object)results);
        return results;
    }

    public Set<VertexRef> getVertexRefsBy(SearchResult searchResult, GraphContainer container) {
        DefaultVertexRef vertexToFocus = new DefaultVertexRef(searchResult.getNamespace(), searchResult.getId(), searchResult.getLabel());
        return Sets.newHashSet((Object[])new VertexRef[]{vertexToFocus});
    }

    public void addVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        LOG.debug("BusinessServiceSearchProvider->addVertexHopCriteria: called with search result: '{}'", (Object)searchResult);
        VertexHopGraphProvider.DefaultVertexHopCriteria criterion = new VertexHopGraphProvider.DefaultVertexHopCriteria((VertexRef)new DefaultVertexRef(searchResult.getNamespace(), searchResult.getId(), searchResult.getLabel()));
        container.addCriteria((org.opennms.features.topology.api.topo.Criteria)criterion);
        LOG.debug("BusinessServiceSearchProvider->addVertexHop: adding hop criteria {}.", (Object)criterion);
        LOG.debug("BusinessServiceSearchProvider->addVertexHop: current criteria {}.", (Object)Arrays.toString(container.getCriteria()));
    }

    public void removeVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        LOG.debug("BusinessServiceSearchProvider->removeVertexHopCriteria: called with search result: '{}'", (Object)searchResult);
        VertexHopGraphProvider.DefaultVertexHopCriteria criterion = new VertexHopGraphProvider.DefaultVertexHopCriteria((VertexRef)new DefaultVertexRef(searchResult.getNamespace(), searchResult.getId(), searchResult.getLabel()));
        container.removeCriteria((org.opennms.features.topology.api.topo.Criteria)criterion);
        LOG.debug("BusinessServiceSearchProvider->removeVertexHopCriteria: current criteria {}.", (Object)Arrays.toString(container.getCriteria()));
    }

    public void setBusinessServiceManager(BusinessServiceManager businessServiceManager) {
        this.businessServiceManager = Objects.requireNonNull(businessServiceManager);
    }
}

