/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm.info;

import com.vaadin.data.Property;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.NativeSelect;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.info.VertexInfoPanelItem;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.bsm.ReductionKeyVertex;
import org.opennms.features.topology.plugins.topo.bsm.simulate.SetStatusToCriteria;
import org.opennms.features.topology.plugins.topo.bsm.simulate.SimulationAwareStateMachineFactory;
import org.opennms.netmgt.bsm.service.model.Status;

public class SimulationModeReductionKeyInfoPanelItem
extends VertexInfoPanelItem {
    public boolean contributesTo(VertexRef ref, GraphContainer container) {
        return ref instanceof ReductionKeyVertex && SimulationAwareStateMachineFactory.isInSimulationMode(container.getCriteria());
    }

    public Component getComponent(VertexRef ref, GraphContainer container) {
        ReductionKeyVertex vertex = (ReductionKeyVertex)ref;
        FormLayout formLayout = new FormLayout();
        formLayout.setSpacing(false);
        formLayout.setMargin(false);
        NativeSelect dropdown = new NativeSelect("Severity");
        dropdown.setMultiSelect(false);
        dropdown.setNewItemsAllowed(false);
        dropdown.setNullSelectionAllowed(true);
        dropdown.setImmediate(true);
        dropdown.setRequired(true);
        dropdown.addItems(Arrays.asList(Status.values()));
        SetStatusToCriteria setStatusTo = SimulationModeReductionKeyInfoPanelItem.findCriteria(container, vertex);
        if (setStatusTo != null) {
            dropdown.setValue((Object)setStatusTo.getStatus());
        } else {
            dropdown.setValue(null);
        }
        dropdown.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            SetStatusToCriteria currentSetStatusTo = SimulationModeReductionKeyInfoPanelItem.findCriteria(container, vertex);
            Status selectedStatus = (Status)dropdown.getValue();
            if (currentSetStatusTo != null) {
                currentSetStatusTo.setStatus(selectedStatus);
            } else {
                currentSetStatusTo = new SetStatusToCriteria(vertex.getReductionKey(), selectedStatus);
                container.addCriteria((Criteria)currentSetStatusTo);
            }
            container.getSelectionManager().setSelectedVertexRefs(Collections.emptyList());
            container.getSelectionManager().setSelectedEdgeRefs(Collections.emptyList());
            container.redoLayout();
        });
        formLayout.addComponent((Component)dropdown);
        return formLayout;
    }

    public String getTitle(VertexRef ref) {
        return "Simulate";
    }

    public int getOrder() {
        return 0;
    }

    private static SetStatusToCriteria findCriteria(GraphContainer container, ReductionKeyVertex vertex) {
        for (SetStatusToCriteria set : container.findCriteria(SetStatusToCriteria.class)) {
            if (!vertex.getReductionKey().equals(set.getReductionKey())) continue;
            return set;
        }
        return null;
    }
}

