/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm.info;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Table;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.info.VertexInfoPanelItem;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.bsm.AbstractBusinessServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertexVisitor;
import org.opennms.features.topology.plugins.topo.bsm.GraphVertexToTopologyVertexConverter;
import org.opennms.features.topology.plugins.topo.bsm.IpServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.ReductionKeyVertex;
import org.opennms.features.topology.plugins.topo.bsm.info.BusinessServiceVertexStatusInfoPanelItem;
import org.opennms.features.topology.plugins.topo.bsm.simulate.SimulationAwareStateMachineFactory;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.IpService;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.functions.reduce.HighestSeverity;
import org.opennms.netmgt.bsm.service.model.functions.reduce.HighestSeverityAbove;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReduceFunctionVisitor;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReductionFunction;
import org.opennms.netmgt.bsm.service.model.functions.reduce.Threshold;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ThresholdResultExplanation;
import org.opennms.netmgt.bsm.service.model.graph.GraphEdge;
import org.opennms.netmgt.vaadin.core.TransactionAwareBeanProxyFactory;
import org.opennms.netmgt.vaadin.core.UIHelper;

public class BusinessServiceVertexInfoPanelItem
extends VertexInfoPanelItem {
    private BusinessServiceManager businessServiceManager;
    private final TransactionAwareBeanProxyFactory transactionAwareBeanProxyFactory;

    public BusinessServiceVertexInfoPanelItem(TransactionAwareBeanProxyFactory transactionAwareBeanProxyFactory) {
        this.transactionAwareBeanProxyFactory = transactionAwareBeanProxyFactory;
    }

    public void setBusinessServiceManager(BusinessServiceManager businessServiceManager) {
        this.businessServiceManager = (BusinessServiceManager)this.transactionAwareBeanProxyFactory.createProxy((Object)businessServiceManager);
    }

    protected boolean contributesTo(VertexRef vertexRef, GraphContainer container) {
        return vertexRef.getNamespace().equals("bsm");
    }

    protected Component getComponent(VertexRef ref, final GraphContainer container) {
        final FormLayout formLayout = new FormLayout();
        formLayout.setSpacing(false);
        formLayout.setMargin(false);
        ((AbstractBusinessServiceVertex)ref).accept(new BusinessServiceVertexVisitor<Void>(){

            @Override
            public Void visit(BusinessServiceVertex vertex) {
                final BusinessService businessService = BusinessServiceVertexInfoPanelItem.this.businessServiceManager.getBusinessServiceById(vertex.getServiceId());
                formLayout.addComponent((Component)UIHelper.createLabel((String)"Reduce function", (String)BusinessServiceVertexInfoPanelItem.getReduceFunctionDescription(businessService.getReduceFunction())));
                businessService.getReduceFunction().accept((ReduceFunctionVisitor)new ReduceFunctionVisitor<Void>(){

                    public Void visit(HighestSeverity highestSeverity) {
                        return null;
                    }

                    public Void visit(HighestSeverityAbove highestSeverityAbove) {
                        return null;
                    }

                    public Void visit(Threshold threshold) {
                        Button explainButton = UIHelper.createButton((String)"Explain", (String)"Explain the Threshold function", (Resource)FontAwesome.TABLE, (Button.ClickListener & Serializable)event -> {
                            ThresholdExplanationWindow explainWindow = new ThresholdExplanationWindow(SimulationAwareStateMachineFactory.createSimulatedStateMachine(BusinessServiceVertexInfoPanelItem.this.businessServiceManager, container.getCriteria()).explain(businessService, (Threshold)businessService.getReduceFunction()));
                            UI.getCurrent().addWindow((Window)explainWindow);
                        });
                        explainButton.setStyleName("link");
                        formLayout.addComponent((Component)explainButton);
                        return null;
                    }
                });
                return null;
            }

            @Override
            public Void visit(IpServiceVertex vertex) {
                IpService ipService = BusinessServiceVertexInfoPanelItem.this.businessServiceManager.getIpServiceById(vertex.getIpServiceId());
                formLayout.addComponent((Component)UIHelper.createLabel((String)"Interface", (String)ipService.getIpAddress()));
                formLayout.addComponent((Component)UIHelper.createLabel((String)"Service", (String)ipService.getServiceName()));
                if (!ipService.getServiceName().equals(vertex.getLabel())) {
                    formLayout.addComponent((Component)UIHelper.createLabel((String)"Friendly Name", (String)vertex.getLabel()));
                }
                return null;
            }

            @Override
            public Void visit(ReductionKeyVertex vertex) {
                formLayout.addComponent((Component)UIHelper.createLabel((String)"Reduction Key", (String)vertex.getReductionKey()));
                if (!vertex.getReductionKey().equals(vertex.getLabel())) {
                    formLayout.addComponent((Component)UIHelper.createLabel((String)"Friendly Name", (String)vertex.getLabel()));
                }
                return null;
            }
        });
        return formLayout;
    }

    protected String getTitle(VertexRef ref) {
        return ((AbstractBusinessServiceVertex)ref).accept(new BusinessServiceVertexVisitor<String>(){

            @Override
            public String visit(BusinessServiceVertex vertex) {
                return "Business Service Details";
            }

            @Override
            public String visit(IpServiceVertex vertex) {
                return "IP Service Details";
            }

            @Override
            public String visit(ReductionKeyVertex vertex) {
                return "Reduction Key Details";
            }
        });
    }

    public int getOrder() {
        return 0;
    }

    private static String getReduceFunctionDescription(ReductionFunction reductionFunction) {
        return (String)reductionFunction.accept((ReduceFunctionVisitor)new ReduceFunctionVisitor<String>(){

            public String visit(HighestSeverity function) {
                return function.getClass().getSimpleName();
            }

            public String visit(HighestSeverityAbove function) {
                return String.format("%s (%s)", function.getClass().getSimpleName(), function.getThreshold().getLabel());
            }

            public String visit(Threshold function) {
                return String.format("%s (%s)", function.getClass().getSimpleName(), Float.toString(function.getThreshold()));
            }
        });
    }

    private static class ThresholdExplanationWindow
    extends Window {
        private static final long serialVersionUID = 1L;
        private static final String EDGE_COLUMN = "Edge";
        private static final String STATUS_COLUMN = "Status";
        private static final String WEIGHT_COLUMN = "Weight";
        private static final String WEIGHT_FACTOR = "Weight Factor";

        private ThresholdExplanationWindow(ThresholdResultExplanation explanation) {
            this.setCaption(String.format("Threshold Function Details (%s)", Float.valueOf(explanation.getFunction().getThreshold())));
            this.setClosable(true);
            this.setCloseShortcut(27, new int[0]);
            this.setResizable(true);
            this.setModal(true);
            this.setWidth(1000.0f, Sizeable.Unit.PIXELS);
            this.setHeight(200.0f, Sizeable.Unit.PIXELS);
            this.addStyleName("threshold");
            this.addStyleName("severity");
            Table table = new Table();
            table.setCellStyleGenerator((Table.CellStyleGenerator & Serializable)(source, itemId, propertyId) -> {
                if (propertyId != null && propertyId.equals(explanation.getStatus())) {
                    return "selected";
                }
                return null;
            });
            table.addContainerProperty((Object)EDGE_COLUMN, String.class, null);
            table.addContainerProperty((Object)STATUS_COLUMN, Label.class, null);
            table.addContainerProperty((Object)WEIGHT_COLUMN, Integer.class, (Object)1);
            table.addContainerProperty((Object)WEIGHT_FACTOR, String.class, null);
            table.addContainerProperty((Object)Status.CRITICAL, String.class, null);
            table.addContainerProperty((Object)Status.MAJOR, String.class, null);
            table.addContainerProperty((Object)Status.MINOR, String.class, null);
            table.addContainerProperty((Object)Status.WARNING, String.class, null);
            table.addContainerProperty((Object)Status.NORMAL, String.class, null);
            List sortedGraphEdges = explanation.getGraphEdges().stream().sorted(Comparator.comparing(GraphEdge::getStatus).reversed().thenComparing(it -> this.getLabel((GraphEdge)it, explanation))).collect(Collectors.toList());
            for (GraphEdge eachEdge : sortedGraphEdges) {
                table.addItem(new Object[]{this.getLabel(eachEdge, explanation), BusinessServiceVertexStatusInfoPanelItem.createStatusLabel(null, eachEdge.getStatus()), eachEdge.getWeight(), this.toString(explanation.getWeightFactor(eachEdge)), this.toString(explanation.getStatusFactor(eachEdge, Status.CRITICAL)), this.toString(explanation.getStatusFactor(eachEdge, Status.MAJOR)), this.toString(explanation.getStatusFactor(eachEdge, Status.MINOR)), this.toString(explanation.getStatusFactor(eachEdge, Status.WARNING)), this.toString(explanation.getStatusFactor(eachEdge, Status.NORMAL))}, (Object)eachEdge);
            }
            table.setFooterVisible(true);
            table.setColumnFooter((Object)EDGE_COLUMN, "Total");
            table.setColumnFooter((Object)STATUS_COLUMN, explanation.getStatus().getLabel());
            table.setColumnFooter((Object)WEIGHT_COLUMN, String.valueOf(explanation.getWeightSum()));
            table.setColumnFooter((Object)WEIGHT_FACTOR, this.toString(explanation.getWeightSumFactor()));
            table.setColumnFooter((Object)Status.CRITICAL, this.toString(explanation.getStatusResult(Status.CRITICAL)));
            table.setColumnFooter((Object)Status.MAJOR, this.toString(explanation.getStatusResult(Status.MAJOR)));
            table.setColumnFooter((Object)Status.MINOR, this.toString(explanation.getStatusResult(Status.MINOR)));
            table.setColumnFooter((Object)Status.WARNING, this.toString(explanation.getStatusResult(Status.WARNING)));
            table.setColumnFooter((Object)Status.NORMAL, this.toString(explanation.getStatusResult(Status.NORMAL)));
            VerticalLayout root = new VerticalLayout();
            table.setSizeFull();
            root.addComponent((Component)table);
            root.setExpandRatio((Component)table, 1.0f);
            root.setSizeFull();
            this.setContent((Component)root);
            this.center();
        }

        private String getLabel(GraphEdge graphEdge, ThresholdResultExplanation explanation) {
            if (graphEdge.getFriendlyName() != null) {
                return graphEdge.getFriendlyName();
            }
            return GraphVertexToTopologyVertexConverter.createTopologyVertex(explanation.getGraphVertex(graphEdge)).getLabel();
        }

        private String toString(double weightFactor) {
            if (weightFactor == 0.0) {
                return "";
            }
            return String.format("%1.2f", weightFactor);
        }
    }
}

