/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm.operations;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opennms.features.topology.api.AbstractCheckedOperation;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServicesHideLeafsCriteria;

public class HideLeafElementToggleOperation
extends AbstractCheckedOperation {
    public void execute(List<VertexRef> targets, OperationContext operationContext) {
        this.toggle(operationContext.getGraphContainer());
    }

    protected boolean enabled(GraphContainer container) {
        return "bsm".equals(container.getBaseTopology().getVertexNamespace());
    }

    public boolean display(List<VertexRef> targets, OperationContext operationContext) {
        return true;
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    protected boolean isChecked(GraphContainer container) {
        return this.findShowLeafCriteria(container) != null;
    }

    public Map<String, String> createHistory(GraphContainer container) {
        return Collections.singletonMap(((Object)((Object)this)).getClass().getName(), Boolean.toString(this.isChecked(container)));
    }

    public void applyHistory(GraphContainer container, Map<String, String> settings) {
        if ("true".equals(settings.get(((Object)((Object)this)).getClass().getName()))) {
            this.toggle(container);
        }
    }

    private BusinessServicesHideLeafsCriteria findShowLeafCriteria(GraphContainer container) {
        return (BusinessServicesHideLeafsCriteria)Criteria.getSingleCriteriaForGraphContainer((GraphContainer)container, BusinessServicesHideLeafsCriteria.class, (boolean)false);
    }

    private void toggle(GraphContainer container) {
        BusinessServicesHideLeafsCriteria showLeafCriteria = this.findShowLeafCriteria(container);
        if (showLeafCriteria == null) {
            container.addCriteria((Criteria)new BusinessServicesHideLeafsCriteria());
        } else {
            container.removeCriteria((Criteria)showLeafCriteria);
        }
        container.redoLayout();
    }
}

