/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultStatus;
import org.opennms.features.topology.api.topo.EdgeProvider;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.EdgeStatusProvider;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.features.topology.api.topo.StatusProvider;
import org.opennms.features.topology.api.topo.VertexProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.bsm.AbstractBusinessServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceEdge;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertexVisitor;
import org.opennms.features.topology.plugins.topo.bsm.IpServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.ReductionKeyVertex;
import org.opennms.features.topology.plugins.topo.bsm.simulate.SimulationAwareStateMachineFactory;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.BusinessServiceStateMachine;
import org.opennms.netmgt.bsm.service.model.graph.BusinessServiceGraph;
import org.opennms.netmgt.bsm.service.model.graph.GraphEdge;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;

public class BusinessServicesStatusProvider
implements StatusProvider,
EdgeStatusProvider {
    private BusinessServiceManager businessServiceManager;

    public Map<VertexRef, Status> getStatusForVertices(VertexProvider vertexProvider, Collection<VertexRef> vertices, Criteria[] criteria) {
        BusinessServiceStateMachine stateMachine = SimulationAwareStateMachineFactory.createStateMachine(this.businessServiceManager, criteria);
        return vertices.stream().filter(v -> this.contributesTo(v.getNamespace()) && v instanceof AbstractBusinessServiceVertex).map(v -> (AbstractBusinessServiceVertex)((Object)v)).collect(Collectors.toMap(v -> v, v -> new DefaultStatus(BusinessServicesStatusProvider.getStatus(stateMachine, v).getLabel(), 0L)));
    }

    public Map<EdgeRef, Status> getStatusForEdges(EdgeProvider edgeProvider, Collection<EdgeRef> edges, Criteria[] criteria) {
        BusinessServiceStateMachine stateMachine = SimulationAwareStateMachineFactory.createStateMachine(this.businessServiceManager, criteria);
        return edges.stream().filter(edge -> this.contributesTo(edge.getNamespace()) && edge instanceof BusinessServiceEdge).map(edge -> (BusinessServiceEdge)((Object)edge)).collect(Collectors.toMap(edge -> edge, edge -> new DefaultStatus(BusinessServicesStatusProvider.getStatus(stateMachine, edge).getLabel(), 0L)));
    }

    public static org.opennms.netmgt.bsm.service.model.Status getStatus(BusinessServiceStateMachine stateMachine, AbstractBusinessServiceVertex vertex) {
        GraphVertex graphVertex = BusinessServicesStatusProvider.getGraphVertex(vertex, stateMachine.getGraph());
        return graphVertex != null ? graphVertex.getStatus() : null;
    }

    public static org.opennms.netmgt.bsm.service.model.Status getStatus(BusinessServiceStateMachine stateMachine, BusinessServiceEdge edge) {
        GraphVertex target;
        GraphVertex source;
        BusinessServiceGraph graph = stateMachine.getGraph();
        GraphEdge graphEdge = (GraphEdge)graph.findEdge((Object)(source = BusinessServicesStatusProvider.getGraphVertex(edge.getBusinessServiceSource(), stateMachine.getGraph())), (Object)(target = BusinessServicesStatusProvider.getGraphVertex(edge.getBusinessServiceTarget(), stateMachine.getGraph())));
        return graphEdge != null ? graphEdge.getStatus() : null;
    }

    private static GraphVertex getGraphVertex(AbstractBusinessServiceVertex vertex, final BusinessServiceGraph graph) {
        final AtomicReference graphVertex = new AtomicReference();
        vertex.accept(new BusinessServiceVertexVisitor<Void>(){

            @Override
            public Void visit(BusinessServiceVertex vertex) {
                graphVertex.set(graph.getVertexByBusinessServiceId(vertex.getServiceId()));
                return null;
            }

            @Override
            public Void visit(IpServiceVertex vertex) {
                graphVertex.set(graph.getVertexByIpServiceId(vertex.getIpServiceId()));
                return null;
            }

            @Override
            public Void visit(ReductionKeyVertex vertex) {
                graphVertex.set(graph.getVertexByReductionKey(vertex.getReductionKey()));
                return null;
            }
        });
        return (GraphVertex)graphVertex.get();
    }

    public String getNamespace() {
        return "bsm";
    }

    public boolean contributesTo(String namespace) {
        return this.getNamespace().equals(namespace);
    }

    public void setBusinessServiceManager(BusinessServiceManager businessServiceManager) {
        this.businessServiceManager = Objects.requireNonNull(businessServiceManager);
    }
}

