/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2016 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2016 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/

package org.opennms.features.topology.plugins.topo.bsm.info;

import java.util.Arrays;

import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.info.VertexInfoPanelItem;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.bsm.ReductionKeyVertex;
import org.opennms.features.topology.plugins.topo.bsm.simulate.SetStatusToCriteria;
import org.opennms.features.topology.plugins.topo.bsm.simulate.SimulationAwareStateMachineFactory;
import org.opennms.netmgt.bsm.service.model.Status;

import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.NativeSelect;

public class SimulationModeReductionKeyInfoPanelItem extends VertexInfoPanelItem {

    @Override
    public boolean contributesTo(VertexRef ref, GraphContainer container) {
        return ref instanceof ReductionKeyVertex && SimulationAwareStateMachineFactory.isInSimulationMode(container.getCriteria());
    }

    @Override
    public Component getComponent(VertexRef ref, GraphContainer container) {
        final ReductionKeyVertex vertex = (ReductionKeyVertex)ref;
        final FormLayout formLayout = new FormLayout();
        formLayout.setSpacing(false);
        formLayout.setMargin(false);

        NativeSelect dropdown = new NativeSelect("Severity");
        dropdown.setMultiSelect(false);
        dropdown.setNewItemsAllowed(false);
        dropdown.setNullSelectionAllowed(true);
        dropdown.setImmediate(true);
        dropdown.setRequired(true);
        dropdown.addItems(Arrays.asList(Status.values()));

        SetStatusToCriteria setStatusTo = findCriteria(container, vertex);
        if (setStatusTo != null) {
            dropdown.setValue(setStatusTo.getStatus());
        } else {
            dropdown.setValue(null);
        }

        dropdown.addValueChangeListener(event -> {
            // The set of criteria may have changed since we last queried it above
            // do we issue try finding it again, instead of using the same existing object
            SetStatusToCriteria currentSetStatusTo = findCriteria(container, vertex);
            Status selectedStatus = (Status)dropdown.getValue();
            if (currentSetStatusTo != null) {
                currentSetStatusTo.setStatus(selectedStatus);
            } else {
                currentSetStatusTo = new SetStatusToCriteria(vertex.getReductionKey(), selectedStatus);
                container.addCriteria(currentSetStatusTo);
            }
            container.redoLayout();
        });
        formLayout.addComponent(dropdown);

        return formLayout;
    }

    @Override
    public String getTitle(VertexRef ref) {
        return "Simulate";
    }

    @Override
    public int getOrder() {
        return 0;
    }

    private static SetStatusToCriteria findCriteria(GraphContainer container, ReductionKeyVertex vertex) {
        for (SetStatusToCriteria set : container.findCriteria(SetStatusToCriteria.class)) {
            if (vertex.getReductionKey().equals(set.getReductionKey())) {
                return set;
            }
        }
        return null;
    }
}
