/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.application;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.support.VertexHopGraphProvider;
import org.opennms.features.topology.api.topo.AbstractSearchProvider;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.SearchProvider;
import org.opennms.features.topology.api.topo.SearchQuery;
import org.opennms.features.topology.api.topo.SearchResult;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.application.ApplicationVertex;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.vaadin.core.TransactionAwareBeanProxyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationSearchProvider
extends AbstractSearchProvider
implements SearchProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationSearchProvider.class);
    private final TransactionAwareBeanProxyFactory transactionAwareBeanProxyFactory;
    private ApplicationDao applicationDao;

    public ApplicationSearchProvider(TransactionAwareBeanProxyFactory transactionAwareBeanProxyFactory) {
        this.transactionAwareBeanProxyFactory = Objects.requireNonNull(transactionAwareBeanProxyFactory);
    }

    public String getSearchProviderNamespace() {
        return "application";
    }

    public boolean contributesTo(String namespace) {
        return "application".equalsIgnoreCase(namespace);
    }

    public boolean supportsPrefix(String searchPrefix) {
        return ApplicationSearchProvider.supportsPrefix((String)"application=", (String)searchPrefix);
    }

    public List<SearchResult> query(SearchQuery searchQuery, GraphContainer container) {
        LOG.info("ApplicationServiceSearchProvider->query: called with search query: '{}'", (Object)searchQuery);
        ArrayList results = Lists.newArrayList();
        String queryString = searchQuery.getQueryString();
        CriteriaBuilder bldr = new CriteriaBuilder(OnmsApplication.class);
        if (queryString != null && queryString.length() > 0) {
            bldr.ilike("name", (Object)String.format("%%%s%%", queryString));
        }
        bldr.orderBy("name", true);
        bldr.limit(Integer.valueOf(10));
        Criteria dbQueryCriteria = bldr.toCriteria();
        for (OnmsApplication application : this.applicationDao.findMatching(dbQueryCriteria)) {
            ApplicationVertex applicationVertex = new ApplicationVertex(application);
            SearchResult searchResult = new SearchResult((VertexRef)applicationVertex);
            searchResult.setCollapsed(false);
            searchResult.setCollapsible(true);
            results.add(searchResult);
        }
        LOG.info("ApplicationServiceSearchProvider->query: found {} results: {}", (Object)results.size(), (Object)results);
        return results;
    }

    public Set<VertexRef> getVertexRefsBy(SearchResult searchResult, GraphContainer container) {
        DefaultVertexRef vertexToFocus = new DefaultVertexRef(searchResult.getNamespace(), searchResult.getId(), searchResult.getLabel());
        return Sets.newHashSet((Object[])new VertexRef[]{vertexToFocus});
    }

    public void addVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        LOG.debug("ApplicationServiceSearchProvider->addVertexHopCriteria: called with search result: '{}'", (Object)searchResult);
        VertexHopGraphProvider.DefaultVertexHopCriteria criterion = new VertexHopGraphProvider.DefaultVertexHopCriteria((VertexRef)new DefaultVertexRef(searchResult.getNamespace(), searchResult.getId(), searchResult.getLabel()));
        container.addCriteria((org.opennms.features.topology.api.topo.Criteria)criterion);
        LOG.debug("ApplicationServiceSearchProvider->addVertexHop: adding hop criteria {}.", (Object)criterion);
        LOG.debug("ApplicationServiceSearchProvider->addVertexHop: current criteria {}.", (Object)Arrays.toString(container.getCriteria()));
    }

    public void removeVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        LOG.debug("ApplicationServiceSearchProvider->removeVertexHopCriteria: called with search result: '{}'", (Object)searchResult);
        VertexHopGraphProvider.DefaultVertexHopCriteria criterion = new VertexHopGraphProvider.DefaultVertexHopCriteria((VertexRef)new DefaultVertexRef(searchResult.getNamespace(), searchResult.getId(), searchResult.getLabel()));
        container.removeCriteria((org.opennms.features.topology.api.topo.Criteria)criterion);
        LOG.debug("ApplicationServiceSearchProvider->removeVertexHopCriteria: current criteria {}.", (Object)Arrays.toString(container.getCriteria()));
    }

    public void setApplicationDao(ApplicationDao applicationDao) {
        this.applicationDao = (ApplicationDao)this.transactionAwareBeanProxyFactory.createProxy((Object)applicationDao);
    }
}

