/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.ncs;

import com.google.common.collect.Lists;
import com.vaadin.data.Item;
import com.vaadin.data.util.BeanItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.EdgeListener;
import org.opennms.features.topology.api.topo.EdgeProvider;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.ncs.NCSComponent;
import org.opennms.netmgt.model.ncs.NCSComponentRepository;
import org.slf4j.LoggerFactory;

public class NCSEdgeProvider
implements EdgeProvider {
    private static final String HTML_TOOLTIP_TAG_OPEN = "<p>";
    private static final String HTML_TOOLTIP_TAG_END = "</p>";
    private NCSComponentRepository m_dao;
    private NodeDao m_nodeDao;

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao dao) {
        this.m_nodeDao = dao;
    }

    public NCSComponentRepository getNcsComponentRepository() {
        return this.m_dao;
    }

    public void setNcsComponentRepository(NCSComponentRepository dao) {
        this.m_dao = dao;
    }

    public void addEdgeListener(EdgeListener vertexListener) {
    }

    public Edge getEdge(String namespace, String id) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Edge getEdge(EdgeRef reference) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<Edge> getEdges(Criteria ... criteria) {
        ArrayList<Edge> retval = new ArrayList<Edge>();
        for (Criteria criterium : criteria) {
            try {
                NCSServiceCriteria crit = (NCSServiceCriteria)criterium;
                for (Long id : crit) {
                    NCSComponent service = this.m_dao.get(id);
                    if (service == null) {
                        LoggerFactory.getLogger(this.getClass()).warn("NCSComponent not found for ID {}", (Object)id);
                        continue;
                    }
                    NCSComponent[] subs = this.checkForeignSource(service.getForeignSource(), service.getSubcomponents());
                    for (int i = 0; i < subs.length; ++i) {
                        for (int j = i + 1; j < subs.length; ++j) {
                            String foreignSource = null;
                            String foreignId = null;
                            OnmsNode sourceNode = null;
                            OnmsNode targetNode = null;
                            NCSComponent.NodeIdentification ident = subs[i].getNodeIdentification();
                            String sourceLabel = subs[i].getName();
                            if (ident != null) {
                                foreignSource = ident.getForeignSource();
                                sourceNode = this.m_nodeDao.findByForeignId(foreignSource, foreignId = ident.getForeignId());
                                if (sourceNode == null) continue;
                                if (sourceLabel == null) {
                                    sourceLabel = sourceNode.getLabel();
                                }
                            }
                            ident = subs[j].getNodeIdentification();
                            String targetLabel = subs[j].getName();
                            if (ident != null) {
                                foreignSource = ident.getForeignSource();
                                targetNode = this.m_nodeDao.findByForeignId(foreignSource, foreignId = ident.getForeignId());
                                if (targetNode == null) continue;
                                if (targetLabel == null) {
                                    targetLabel = targetNode.getLabel();
                                }
                            }
                            String sourceElementName = subs[i].getForeignSource() + "::" + subs[i].getForeignId();
                            String targetElementName = subs[j].getForeignSource() + "::" + subs[j].getForeignId();
                            retval.add((Edge)new NCSEdge(subs[i].getForeignId(), service.getName(), sourceElementName, targetElementName, new NCSVertex(String.valueOf(sourceNode.getId()), sourceLabel), new NCSVertex(String.valueOf(targetNode.getId()), targetLabel)));
                        }
                    }
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return retval;
    }

    private NCSComponent[] checkForeignSource(String foreignSource, Set<NCSComponent> subcomponents) {
        HashSet<NCSComponent> retVal = new HashSet<NCSComponent>();
        for (NCSComponent component : subcomponents) {
            if (!component.getForeignSource().equals(foreignSource)) continue;
            retVal.add(component);
        }
        return retVal.toArray(new NCSComponent[0]);
    }

    public List<Edge> getEdges(Collection<? extends EdgeRef> references) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getNamespace() {
        return "ncs";
    }

    public boolean contributesTo(String namespace) {
        return "nodes".equals(namespace);
    }

    public void removeEdgeListener(EdgeListener vertexListener) {
    }

    public static Criteria createCriteria(Collection<Long> selectedIds) {
        return new NCSServiceCriteria(selectedIds);
    }

    public void clearEdges() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getEdgeTotalCount() {
        return this.getEdges(new Criteria[0]).size();
    }

    public static class NCSServiceCriteria
    extends Criteria
    implements Iterable<Long> {
        private static final long serialVersionUID = 5833460704861282509L;
        private List<Long> m_ncsServiceList;

        public NCSServiceCriteria(Collection<Long> serviceIds) {
            this.m_ncsServiceList = Lists.newArrayList(serviceIds);
        }

        public String getNamespace() {
            return "ncs";
        }

        public int hashCode() {
            return this.m_ncsServiceList.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof NCSServiceCriteria) {
                NCSServiceCriteria c = (NCSServiceCriteria)obj;
                return c.m_ncsServiceList.equals(this.m_ncsServiceList);
            }
            return false;
        }

        public Criteria.ElementType getType() {
            return Criteria.ElementType.EDGE;
        }

        @Override
        public Iterator<Long> iterator() {
            return this.m_ncsServiceList.iterator();
        }

        public int getServiceCount() {
            return this.m_ncsServiceList.size();
        }

        public List<Long> getServiceIds() {
            return this.m_ncsServiceList;
        }
    }

    public static class NCSVertex
    extends AbstractVertex {
        public NCSVertex(String id, String label) {
            super("nodes", id);
            this.setLabel(label);
        }
    }

    public static class NCSEdge
    extends AbstractEdge {
        private final String m_serviceName;
        private final String m_sourceElementName;
        private final String m_targetElementName;
        private String m_status = "";

        public NCSEdge(String serviceId, String serviceName, String sourceElementName, String targetElementName, NCSVertex source, NCSVertex target) {
            super("ncs", serviceId + "::" + source.getId() + ":::" + target.getId(), (VertexRef)source, (VertexRef)target);
            this.m_serviceName = serviceName;
            this.m_sourceElementName = sourceElementName;
            this.m_targetElementName = targetElementName;
            this.setStyleName("ncs edge");
        }

        public String getTooltipText() {
            StringBuilder toolTip = new StringBuilder();
            toolTip.append(NCSEdgeProvider.HTML_TOOLTIP_TAG_OPEN);
            toolTip.append("Service: " + this.m_serviceName);
            toolTip.append(NCSEdgeProvider.HTML_TOOLTIP_TAG_END);
            if (this.m_status != null) {
                toolTip.append(NCSEdgeProvider.HTML_TOOLTIP_TAG_OPEN);
                toolTip.append("Status: " + this.m_status);
                toolTip.append(NCSEdgeProvider.HTML_TOOLTIP_TAG_END);
                this.m_status = null;
            }
            toolTip.append(NCSEdgeProvider.HTML_TOOLTIP_TAG_OPEN);
            toolTip.append("Source: " + this.getSource().getVertex().getLabel());
            toolTip.append(NCSEdgeProvider.HTML_TOOLTIP_TAG_END);
            toolTip.append(NCSEdgeProvider.HTML_TOOLTIP_TAG_OPEN);
            toolTip.append("Target: " + this.getTarget().getVertex().getLabel());
            toolTip.append(NCSEdgeProvider.HTML_TOOLTIP_TAG_END);
            return toolTip.toString();
        }

        public Item getItem() {
            return new BeanItem((Object)this);
        }

        public String getTargetElementName() {
            return this.m_targetElementName;
        }

        public String getSourceElementName() {
            return this.m_sourceElementName;
        }

        public void setStatus(String status) {
            this.m_status = status;
        }
    }
}

