/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.ncs.internal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.opennms.features.topology.api.topo.Criteria;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.LoggerFactory;

public class NCSCriteriaServiceManager {
    private Map<String, List<ServiceRegistration<Criteria>>> m_registrationMap = new HashMap<String, List<ServiceRegistration<Criteria>>>();
    private BundleContext m_bundleContext;

    public void registerCriteria(Criteria ncsCriteria, String sessionId) {
        this.removeServicesForSessionWithNamespace(sessionId, ncsCriteria.getNamespace());
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("sessionId", sessionId);
        ((Dictionary)properties).put("namespace", ncsCriteria.getNamespace());
        ServiceRegistration registeredService = this.m_bundleContext.registerService(Criteria.class, (Object)ncsCriteria, properties);
        if (this.m_registrationMap.containsKey(sessionId)) {
            List<ServiceRegistration<Criteria>> list = this.m_registrationMap.get(sessionId);
            list.add((ServiceRegistration<Criteria>)registeredService);
        } else {
            ArrayList<ServiceRegistration> serviceList = new ArrayList<ServiceRegistration>();
            serviceList.add(registeredService);
            this.m_registrationMap.put(sessionId, serviceList);
        }
    }

    private void removeServicesForSessionWithNamespace(String sessionId, String namespace) {
        if (this.m_registrationMap.containsKey(sessionId)) {
            List<ServiceRegistration<Criteria>> serviceList = this.m_registrationMap.get(sessionId);
            ServiceRegistration<Criteria> removedService = null;
            for (ServiceRegistration<Criteria> serviceReg : serviceList) {
                try {
                    String namespaceProperty = (String)serviceReg.getReference().getProperty("namespace");
                    if (!namespaceProperty.equals(namespace)) continue;
                    serviceReg.unregister();
                    removedService = serviceReg;
                }
                catch (IllegalStateException e) {
                    removedService = serviceReg;
                }
            }
            if (removedService != null) {
                serviceList.remove(removedService);
            }
        }
    }

    private void removeAllServicesForSession(String sessionId) {
        if (this.m_registrationMap.containsKey(sessionId)) {
            List<ServiceRegistration<Criteria>> serviceList = this.m_registrationMap.get(sessionId);
            for (ServiceRegistration<Criteria> serviceReg : serviceList) {
                try {
                    serviceReg.unregister();
                }
                catch (IllegalStateException e) {
                    LoggerFactory.getLogger(this.getClass()).warn("Attempted to unregister a service that is already unregistered {}", (Throwable)e);
                }
            }
            serviceList.clear();
        }
    }

    protected void removeAllServices() {
        for (String key : this.m_registrationMap.keySet()) {
            this.removeAllServicesForSession(key);
        }
    }

    public void setBundleContext(BundleContext context) {
        this.m_bundleContext = context;
        this.m_bundleContext.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                switch (event.getType()) {
                    case 256: {
                        NCSCriteriaServiceManager.this.removeAllServices();
                    }
                }
            }
        });
    }

    public boolean isCriteriaRegistered(String namespace, String sessionId) {
        List<ServiceRegistration<Criteria>> registrationList = this.m_registrationMap.get(sessionId);
        if (registrationList != null) {
            for (ServiceRegistration<Criteria> critRegistration : registrationList) {
                String namespaceProperty = (String)critRegistration.getReference().getProperty("namespace");
                if (!namespaceProperty.equals(namespace)) continue;
                return true;
            }
        }
        return false;
    }

    public void unregisterCriteria(String namespace, String sessionId) {
        List<ServiceRegistration<Criteria>> registrationList = this.m_registrationMap.get(sessionId);
        ArrayList<ServiceRegistration<Criteria>> clearedList = new ArrayList<ServiceRegistration<Criteria>>();
        for (ServiceRegistration<Criteria> criteriaRegistration : registrationList) {
            String namespaceProperty = (String)criteriaRegistration.getReference().getProperty("namespace");
            if (!namespaceProperty.equals(namespace)) continue;
            criteriaRegistration.unregister();
            clearedList.add(criteriaRegistration);
        }
        if (clearedList.size() > 0) {
            registrationList.removeAll(clearedList);
        }
    }

    public void addCriteriaServiceListener(ServiceListener listener, String sessionId, String namespace) {
        try {
            this.m_bundleContext.addServiceListener(listener, "(&(objectClass=org.opennms.features.topology.api.topo.Criteria)(sessionId=" + sessionId + ")(namespace=" + namespace + "))");
        }
        catch (InvalidSyntaxException e) {
            LoggerFactory.getLogger(this.getClass()).error("addCriteriaServiceListener() failed", (Throwable)e);
        }
    }

    public void removeCriteriaServiceListener(ServiceListener listener) {
        this.m_bundleContext.removeServiceListener(listener);
    }
}

