/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.ncs;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.features.topology.api.topo.EdgeProvider;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.EdgeStatusProvider;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.features.topology.plugins.ncs.NCSEdgeProvider;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsEventParameter;

public class NCSEdgeStatusProvider
implements EdgeStatusProvider {
    private AlarmDao m_alarmDao;

    public String getNamespace() {
        return "ncsPath::NCS";
    }

    public Map<EdgeRef, Status> getStatusForEdges(EdgeProvider edgeProvider, Collection<EdgeRef> edges, org.opennms.features.topology.api.topo.Criteria[] criteria) {
        ArrayList ncsEdges = new ArrayList(Collections2.filter(edges, (Predicate)new Predicate<EdgeRef>(){

            public boolean apply(EdgeRef edgeRef) {
                return edgeRef.getNamespace().equals("ncs");
            }
        }));
        Set<String> alarms = this.getNCSImpactedAlarms();
        HashMap<EdgeRef, Status> statusMap = new HashMap<EdgeRef, Status>();
        for (EdgeRef edge : ncsEdges) {
            NCSEdgeProvider.NCSEdge e = (NCSEdgeProvider.NCSEdge)edge;
            e.setStatus("up");
            statusMap.put(edge, new NCSLinkStatus("up"));
            if (!alarms.contains(e.getSourceElementName()) && !alarms.contains(e.getTargetElementName())) continue;
            statusMap.put(edge, new NCSLinkStatus("down"));
            e.setStatus("down");
        }
        return statusMap;
    }

    private Set<String> getNCSImpactedAlarms() {
        Criteria criteria = new Criteria(OnmsAlarm.class);
        criteria.addRestriction((Restriction)new EqRestriction("uei", (Object)"uei.opennms.org/internal/ncs/componentImpacted"));
        List alarms = this.getAlarmDao().findMatching(criteria);
        HashSet<String> alarmsSet = new HashSet<String>();
        for (OnmsAlarm alarm : alarms) {
            Optional<String> foreignSource = alarm.findEventParameter("foreignSource").map(OnmsEventParameter::getValue);
            Optional<String> foreignId = alarm.findEventParameter("foreignId").map(OnmsEventParameter::getValue);
            if (!foreignSource.isPresent() || !foreignId.isPresent()) continue;
            alarmsSet.add(foreignSource.get() + "::" + foreignId.get());
        }
        return alarmsSet;
    }

    public boolean contributesTo(String namespace) {
        return namespace.equals("nodes");
    }

    public AlarmDao getAlarmDao() {
        return this.m_alarmDao;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public class NCSLinkStatus
    implements Status {
        private final String m_status;

        public NCSLinkStatus(String status) {
            this.m_status = status.toLowerCase();
        }

        public String computeStatus() {
            return this.m_status;
        }

        public Map<String, String> getStatusProperties() {
            return null;
        }

        public Map<String, String> getStyleProperties() {
            return Maps.newHashMap();
        }
    }
}

