/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.ncs;

import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.event.ItemClickEvent;
import com.vaadin.ui.Tree;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.support.FilterableHierarchicalContainer;

public abstract class SelectionTree
extends Tree {
    private final TreeItemClickTracker m_treeItemClickTracker = new TreeItemClickTracker();
    protected GraphContainer m_graphContainer;

    public SelectionTree(FilterableHierarchicalContainer container) {
        super(null, (Container)container);
        this.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                Set selectedIds = (Set)event.getProperty().getValue();
                List allIds = SelectionTree.this.getContainerDataSource().getItemIds();
                Set itemsToSelect = SelectionTree.this.getSelectedItemIds(selectedIds);
                Set itemsToDeselected = SelectionTree.getItemsToDeselect(allIds, itemsToSelect);
                SelectionTree.this.deselectContainerItems(itemsToDeselected);
                SelectionTree.this.selectContainerItemAndChildren(itemsToSelect);
            }
        });
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){

            public void itemClick(ItemClickEvent event) {
                Set selectedIds = (Set)((SelectionTree)((Object)event.getSource())).getValue();
                Object itemId = event.getItemId();
                SelectionTree.this.m_treeItemClickTracker.setClickedItemId(itemId);
                if ((event.isCtrlKey() || event.isMetaKey()) && selectedIds.contains(itemId)) {
                    SelectionTree.this.m_treeItemClickTracker.setRemove(true);
                }
            }
        });
    }

    private Set<Object> getSelectedItemIds(Set<Object> selectedIds) {
        LinkedHashSet<Object> itemsToSelect = new LinkedHashSet<Object>(selectedIds);
        if (this.m_treeItemClickTracker.isRemoved()) {
            if (this.getParent(this.m_treeItemClickTracker.getClickedItemId()) != null) {
                this.unselect(this.getParent(this.m_treeItemClickTracker.getClickedItemId()));
            }
            this.unselect(this.m_treeItemClickTracker.getClickedItemId());
            itemsToSelect.remove(this.m_treeItemClickTracker.getClickedItemId());
        }
        return itemsToSelect;
    }

    private static Set<Object> getItemsToDeselect(Collection<Object> allIds, Set<Object> itemsToSelect) {
        LinkedHashSet<Object> itemsToDeselected = new LinkedHashSet<Object>(allIds);
        itemsToDeselected.removeAll(itemsToSelect);
        return itemsToDeselected;
    }

    private void deselectContainerItems(Set<Object> itemsToDeselected) {
        for (Object itemId : itemsToDeselected) {
            Property property = this.getContainerDataSource().getContainerProperty(itemId, (Object)"selected");
            if (!((Boolean)property.getValue()).booleanValue()) continue;
            property.setValue((Object)false);
        }
    }

    private void selectContainerItemAndChildren(Set<Object> itemsToSelect) {
        for (Object itemId : itemsToSelect) {
            Property property = this.getContainerDataSource().getContainerProperty(itemId, (Object)"selected");
            if (!((Boolean)property.getValue()).booleanValue()) {
                property.setValue((Object)true);
            }
            if (!this.hasChildren(itemId)) continue;
            for (Object id : this.getChildren(itemId)) {
                this.select(id);
            }
        }
        this.getContainerDataSource().fireItemUpdated();
    }

    public FilterableHierarchicalContainer getContainerDataSource() {
        return (FilterableHierarchicalContainer)super.getContainerDataSource();
    }

    public void setGraphContainer(GraphContainer graphContainer) {
        this.m_graphContainer = graphContainer;
    }

    public String toString() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private static class TreeItemClickTracker {
        private Object m_clickedItemId;
        private boolean m_remove;

        public void setClickedItemId(Object itemId) {
            this.m_clickedItemId = itemId;
            this.m_remove = false;
        }

        public Object getClickedItemId() {
            return this.m_clickedItemId;
        }

        public void setRemove(boolean remove) {
            this.m_remove = remove;
        }

        public boolean isRemoved() {
            return this.m_remove;
        }
    }
}

