/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.ncs;

import com.vaadin.data.Item;
import com.vaadin.data.util.BeanItem;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.EdgeListener;
import org.opennms.features.topology.api.topo.EdgeProvider;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.plugins.ncs.NCSEdgeProvider;

public class NCSPathEdgeProvider
implements EdgeProvider {
    public static final String PATH_NAMESPACE = "ncsPath";
    private static final String HTML_TOOLTIP_TAG_OPEN = "<p>";
    private static final String HTML_TOOLTIP_TAG_END = "</p>";

    public String getEdgeNamespace() {
        return PATH_NAMESPACE;
    }

    public boolean contributesTo(String namespace) {
        return "nodes".equals(namespace);
    }

    public Edge getEdge(String namespace, String id) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Edge getEdge(EdgeRef reference) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<Edge> getEdges(Criteria ... criteria) {
        for (Criteria criterium : criteria) {
            try {
                return ((NCSServicePathCriteria)criterium).getEdges();
            }
            catch (ClassCastException classCastException) {
            }
        }
        return Collections.emptyList();
    }

    public List<Edge> getEdges(Collection<? extends EdgeRef> references) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addEdgeListener(EdgeListener listener) {
    }

    public void removeEdgeListener(EdgeListener listener) {
    }

    public void clearEdges() {
    }

    public static class NCSPathEdge
    extends AbstractEdge {
        private final String m_serviceName;
        private final String m_deviceA;
        private final String m_deviceZ;

        public NCSPathEdge(String serviceName, String deviceA, String deviceZ, NCSEdgeProvider.NCSVertex source, NCSEdgeProvider.NCSVertex target) {
            super(NCSPathEdgeProvider.PATH_NAMESPACE, source.getId() + ":::" + target.getId(), (Vertex)source, (Vertex)target);
            this.m_serviceName = serviceName;
            this.m_deviceA = deviceA;
            this.m_deviceZ = deviceZ;
            this.setStyleName("ncs edge");
        }

        public String getTooltipText() {
            StringBuffer toolTip = new StringBuffer();
            toolTip.append(NCSPathEdgeProvider.HTML_TOOLTIP_TAG_OPEN);
            toolTip.append("Service: " + this.m_serviceName);
            toolTip.append(NCSPathEdgeProvider.HTML_TOOLTIP_TAG_END);
            toolTip.append(NCSPathEdgeProvider.HTML_TOOLTIP_TAG_OPEN);
            toolTip.append("Source: " + this.m_deviceA);
            toolTip.append(NCSPathEdgeProvider.HTML_TOOLTIP_TAG_END);
            toolTip.append(NCSPathEdgeProvider.HTML_TOOLTIP_TAG_OPEN);
            toolTip.append("Target: " + this.m_deviceZ);
            toolTip.append(NCSPathEdgeProvider.HTML_TOOLTIP_TAG_END);
            return toolTip.toString();
        }

        public Item getItem() {
            return new BeanItem((Object)this);
        }
    }

    public static class NCSServicePathCriteria
    extends Criteria
    implements Iterable<Edge> {
        private static final long serialVersionUID = 5833760704861282509L;
        private List<Edge> m_edgeList;

        public NCSServicePathCriteria(List<Edge> edges) {
            this.m_edgeList = edges;
        }

        public Criteria.ElementType getType() {
            return Criteria.ElementType.EDGE;
        }

        public String getNamespace() {
            return NCSPathEdgeProvider.PATH_NAMESPACE;
        }

        public int hashCode() {
            return this.m_edgeList.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof NCSServicePathCriteria) {
                NCSServicePathCriteria c = (NCSServicePathCriteria)obj;
                return c.m_edgeList.equals(this.m_edgeList);
            }
            return false;
        }

        public List<Edge> getEdges() {
            return this.m_edgeList;
        }

        @Override
        public Iterator<Edge> iterator() {
            return this.m_edgeList.iterator();
        }
    }
}

