/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.ncs;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.data.util.ObjectProperty;
import com.vaadin.data.util.PropertysetItem;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.Form;
import com.vaadin.ui.FormFieldFactory;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.net.ConnectException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.component.http.HttpOperationFailedException;
import org.opennms.features.topology.api.Operation;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.SelectionManager;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.ncs.NCSEdgeProvider;
import org.opennms.features.topology.plugins.ncs.NCSPathEdgeProvider;
import org.opennms.features.topology.plugins.ncs.NCSPathProviderService;
import org.opennms.features.topology.plugins.ncs.NCSServicePath;
import org.opennms.features.topology.plugins.ncs.internal.NCSCriteriaServiceManager;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.ncs.NCSComponent;
import org.opennms.netmgt.model.ncs.NCSComponentRepository;
import org.slf4j.LoggerFactory;

public class ShowNCSPathOperation
implements Operation {
    private NCSEdgeProvider m_ncsEdgeProvider;
    private NCSPathProviderService m_ncsPathProvider;
    private NCSComponentRepository m_dao;
    private NodeDao m_nodeDao;
    private NCSEdgeProvider.NCSServiceCriteria m_storedCriteria;
    private NCSCriteriaServiceManager m_serviceManager;

    public void execute(List<VertexRef> targets, final OperationContext operationContext) {
        for (Criteria criterium : operationContext.getGraphContainer().getCriteria()) {
            try {
                NCSEdgeProvider.NCSServiceCriteria ncsCriterium = (NCSEdgeProvider.NCSServiceCriteria)criterium;
                if (ncsCriterium.getServiceCount() <= 0) continue;
                this.m_storedCriteria = ncsCriterium;
                break;
            }
            catch (ClassCastException ncsCriterium) {
                // empty catch block
            }
        }
        VertexRef defaultVertRef = targets.get(0);
        final SelectionManager selectionManager = operationContext.getGraphContainer().getSelectionManager();
        final Collection<VertexRef> vertexRefs = this.getVertexRefsForNCSService(this.m_storedCriteria);
        final UI mainWindow = operationContext.getMainWindow();
        final Window ncsPathPrompt = new Window("Show NCS Path");
        ncsPathPrompt.setModal(true);
        ncsPathPrompt.setResizable(false);
        ncsPathPrompt.setWidth("300px");
        ncsPathPrompt.setHeight("220px");
        PropertysetItem item = new PropertysetItem();
        item.addItemProperty((Object)"Device A", (Property)new ObjectProperty((Object)"", String.class));
        item.addItemProperty((Object)"Device Z", (Property)new ObjectProperty((Object)"", String.class));
        FormFieldFactory fieldFactory = new FormFieldFactory(){
            private static final long serialVersionUID = 1L;

            public Field<?> createField(Item item, Object propertyId, Component uiContext) {
                String pid = (String)propertyId;
                ComboBox select = new ComboBox();
                for (VertexRef vertRef : vertexRefs) {
                    select.addItem((Object)vertRef.getId());
                    select.setItemCaption((Object)vertRef.getId(), vertRef.getLabel());
                }
                select.setNewItemsAllowed(false);
                select.setNullSelectionAllowed(false);
                select.setImmediate(true);
                select.setScrollToSelectedItem(true);
                if ("Device A".equals(pid)) {
                    select.setCaption("Device A");
                } else {
                    select.setCaption("Device Z");
                }
                return select;
            }
        };
        final Form promptForm = new Form(){

            public void commit() {
                String deviceZ;
                String deviceA = (String)this.getField("Device A").getValue();
                if (deviceA.equals(deviceZ = (String)this.getField("Device Z").getValue())) {
                    Notification.show((String)"Device A and Device Z cannot be the same", (Notification.Type)Notification.Type.WARNING_MESSAGE);
                    throw new Validator.InvalidValueException("Device A and Device Z cannot be the same");
                }
                OnmsNode nodeA = (OnmsNode)ShowNCSPathOperation.this.m_nodeDao.get((Serializable)Integer.valueOf(deviceA));
                String deviceANodeForeignId = nodeA.getForeignId();
                String nodeForeignSource = nodeA.getForeignSource();
                String deviceZNodeForeignId = ((OnmsNode)ShowNCSPathOperation.this.m_nodeDao.get((Serializable)Integer.valueOf(deviceZ))).getForeignId();
                NCSComponent ncsComponent = ShowNCSPathOperation.this.m_dao.get(ShowNCSPathOperation.this.m_storedCriteria.getServiceIds().get(0));
                String foreignSource = ncsComponent.getForeignSource();
                String foreignId = ncsComponent.getForeignId();
                String serviceName = ncsComponent.getName();
                try {
                    NCSServicePath path = ShowNCSPathOperation.this.getNcsPathProvider().getPath(foreignId, foreignSource, deviceANodeForeignId, deviceZNodeForeignId, nodeForeignSource, serviceName);
                    if (path.getStatusCode() == 200) {
                        NCSPathEdgeProvider.NCSServicePathCriteria criteria = new NCSPathEdgeProvider.NCSServicePathCriteria(path.getEdges());
                        ShowNCSPathOperation.this.m_serviceManager.registerCriteria(criteria, operationContext.getGraphContainer().getSessionId());
                        selectionManager.setSelectedVertexRefs(path.getVertices());
                    } else {
                        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("An error occured while retrieving the NCS Path, Juniper NetworkAppsApi send error code: " + path.getStatusCode());
                        mainWindow.showNotification("An error occurred while retrieving the NCS Path\nStatus Code: " + path.getStatusCode(), Notification.TYPE_ERROR_MESSAGE);
                    }
                }
                catch (Exception e) {
                    if (e.getCause() instanceof ConnectException) {
                        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Connection Exception Occurred while retreiving path {}", (Throwable)e);
                        Notification.show((String)"Connection Refused when attempting to reach the NetworkAppsApi", (Notification.Type)Notification.Type.TRAY_NOTIFICATION);
                    }
                    if (e.getCause() instanceof HttpOperationFailedException) {
                        HttpOperationFailedException httpException = (HttpOperationFailedException)e.getCause();
                        if (httpException.getStatusCode() == 401) {
                            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Authentication error when connecting to NetworkAppsApi {}", (Throwable)httpException);
                            Notification.show((String)"Authentication error when connecting to NetworkAppsApi, please check the username and password", (Notification.Type)Notification.Type.TRAY_NOTIFICATION);
                        } else {
                            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("An error occured while retrieving the NCS Path {}", (Throwable)httpException);
                            Notification.show((String)("An error occurred while retrieving the NCS Path\n" + httpException.getMessage()), (Notification.Type)Notification.Type.TRAY_NOTIFICATION);
                        }
                    }
                    if (e.getCause() instanceof Validator.InvalidValueException) {
                        Notification.show((String)e.getMessage(), (Notification.Type)Notification.Type.ERROR_MESSAGE);
                    }
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Exception Occurred while retreiving path {}", (Throwable)e);
                    Notification.show((String)("An error occurred while calculating the path please check the karaf.log file for the exception: \n" + e.getMessage()), (Notification.Type)Notification.Type.TRAY_NOTIFICATION);
                }
            }
        };
        promptForm.setBuffered(true);
        promptForm.setFormFieldFactory(fieldFactory);
        promptForm.setItemDataSource((Item)item);
        Button ok = new Button("OK");
        ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -2742886456007926688L;

            public void buttonClick(Button.ClickEvent event) {
                promptForm.commit();
                mainWindow.removeWindow(ncsPathPrompt);
            }
        });
        promptForm.getFooter().addComponent((Component)ok);
        Button cancel = new Button("Cancel");
        cancel.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -9026067481179449095L;

            public void buttonClick(Button.ClickEvent event) {
                mainWindow.removeWindow(ncsPathPrompt);
            }
        });
        promptForm.getFooter().addComponent((Component)cancel);
        ncsPathPrompt.setContent((Component)promptForm);
        mainWindow.addWindow(ncsPathPrompt);
        promptForm.getField((Object)"Device A").setValue((Object)defaultVertRef.getId());
    }

    private Collection<VertexRef> getVertexRefsForNCSService(NCSEdgeProvider.NCSServiceCriteria storedCriteria) {
        List<Edge> edges = this.m_ncsEdgeProvider.getEdges(storedCriteria);
        HashSet<VertexRef> vertRefList = new HashSet<VertexRef>();
        for (Edge edge : edges) {
            vertRefList.add(edge.getSource().getVertex());
            vertRefList.add(edge.getTarget().getVertex());
        }
        return vertRefList;
    }

    protected void highlightEdgePaths(NCSServicePath path, GraphProvider graphProvider) {
        Edge edge = graphProvider.getEdge("nodes", path.getEdges().iterator().next().getId());
        edge.setStyleName("ncsSetPath");
    }

    public boolean display(List<VertexRef> targets, OperationContext operationContext) {
        Iterator<VertexRef> iterator = targets.iterator();
        if (iterator.hasNext()) {
            VertexRef targetRef = iterator.next();
            String namespace = targetRef.getNamespace();
            if (!namespace.equals("nodes")) {
                return false;
            }
            for (Criteria criteria : operationContext.getGraphContainer().getCriteria()) {
                try {
                    if (criteria == null || ((NCSEdgeProvider.NCSServiceCriteria)criteria).getServiceCount() != 1) continue;
                    return true;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return false;
        }
        return false;
    }

    public boolean enabled(List<VertexRef> targets, OperationContext operationContext) {
        return this.display(targets, operationContext);
    }

    public String getId() {
        return this.getClass().getSimpleName();
    }

    public NCSEdgeProvider getNcsEdgeProvider() {
        return this.m_ncsEdgeProvider;
    }

    public void setNcsEdgeProvider(NCSEdgeProvider ncsEdgeProvider) {
        this.m_ncsEdgeProvider = ncsEdgeProvider;
    }

    public NCSPathProviderService getNcsPathProvider() {
        return this.m_ncsPathProvider;
    }

    public void setNcsPathProvider(NCSPathProviderService ncsPathProvider) {
        this.m_ncsPathProvider = ncsPathProvider;
    }

    public NCSComponentRepository getDao() {
        return this.m_dao;
    }

    public void setDao(NCSComponentRepository dao) {
        this.m_dao = dao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public void setNcsCriteriaServiceManager(NCSCriteriaServiceManager manager) {
        this.m_serviceManager = manager;
    }
}

