/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.ncs;

import com.vaadin.data.Property;
import com.vaadin.data.util.BeanItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opennms.features.topology.api.support.HierarchicalBeanContainer;
import org.opennms.features.topology.plugins.ncs.NCSRootServiceItem;
import org.opennms.features.topology.plugins.ncs.NCSServiceItem;
import org.opennms.netmgt.model.ncs.NCSComponent;
import org.opennms.netmgt.model.ncs.NCSComponentRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NCSServiceContainer
extends HierarchicalBeanContainer<Long, NCSServiceItem> {
    private static final Logger LOG = LoggerFactory.getLogger(NCSServiceContainer.class);
    private static final long serialVersionUID = 3245953234720320852L;
    private static final String FOREIGN_SOURCE_PROPERTY = "foreignSource";
    private final NCSComponentRepository m_dao;
    private final Set<NCSServiceItem> m_rootItems = new HashSet<NCSServiceItem>();

    public NCSServiceContainer(NCSComponentRepository dao) {
        super(NCSServiceItem.class);
        this.m_dao = dao;
        this.setBeanIdProperty("id");
        List services = this.m_dao.findByType("Service");
        this.createRootItems(services);
        this.addAll(this.m_rootItems);
        this.addAll(this.createListFromComponents(services));
    }

    private void createRootItems(List<NCSComponent> components) {
        HashSet<String> foreignSources = new HashSet<String>();
        for (NCSComponent component : components) {
            if (foreignSources.contains(component.getForeignSource())) continue;
            foreignSources.add(component.getForeignSource());
            this.m_rootItems.add(new NCSRootServiceItem(component));
        }
    }

    private Collection<? extends NCSServiceItem> createListFromComponents(List<NCSComponent> ncsComponents) {
        ArrayList<NCSServiceItem> list = new ArrayList<NCSServiceItem>();
        for (NCSComponent ncsComponent : ncsComponents) {
            list.add(new NCSServiceItem(ncsComponent));
        }
        return list;
    }

    public boolean areChildrenAllowed(Object itemId) {
        BeanItem component = this.getItem(itemId);
        return (Boolean)component.getItemProperty((Object)"childrenAllowed").getValue();
    }

    public Collection<Long> getChildren(Object itemId) {
        BeanItem component = this.getItem(itemId);
        String foreignSource = (String)component.getItemProperty((Object)FOREIGN_SOURCE_PROPERTY).getValue();
        LOG.trace("entering method getChildren");
        ArrayList<Long> retval = new ArrayList<Long>();
        for (Long id : this.getAllItemIds()) {
            boolean isRoot = (Boolean)this.getItem(id).getItemProperty((Object)"isRoot").getValue();
            Property itemProperty = this.getItem(id).getItemProperty((Object)FOREIGN_SOURCE_PROPERTY);
            String fSource = (String)itemProperty.getValue();
            if (isRoot || !fSource.equals(foreignSource)) continue;
            retval.add(id);
        }
        return retval;
    }

    public Long getParent(Object itemId) {
        BeanItem component = this.getItem(itemId);
        Object itemForeignSource = component.getItemProperty((Object)FOREIGN_SOURCE_PROPERTY).getValue();
        for (Long rootId : this.rootItemIds()) {
            BeanItem rootItem = this.getItem(rootId);
            String rootForeignSource = (String)rootItem.getItemProperty((Object)FOREIGN_SOURCE_PROPERTY).getValue();
            if (!rootForeignSource.equals(itemForeignSource)) continue;
            return rootId;
        }
        return null;
    }

    public Collection<Long> rootItemIds() {
        ArrayList<Long> retval = new ArrayList<Long>();
        for (NCSServiceItem item : this.m_rootItems) {
            retval.add(item.getId());
        }
        return retval;
    }

    public boolean setChildrenAllowed(Object itemId, boolean areChildrenAllowed) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot setChildredAllowed() on NCSComponent type");
    }

    public boolean setParent(Object itemId, Object newParentId) throws UnsupportedOperationException {
        return true;
    }
}

