/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.ncs;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.opennms.features.topology.plugins.ncs.NCSServicePath;
import org.slf4j.LoggerFactory;

public class NCSPathProviderService {
    private CamelContext m_camelContext;
    private ProducerTemplate m_template;

    public NCSPathProviderService(CamelContext camelContext) {
        this.m_camelContext = camelContext;
        try {
            this.m_template = this.m_camelContext.createProducerTemplate();
            this.m_template.start();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).warn("Exception Occurred while creating route: ", (Throwable)e);
        }
    }

    public NCSServicePath getPath(String foreignId, String foreignSource, String deviceAForeignId, String deviceZForeignId, String nodeForeignSource, String serviceName) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("foreignId", foreignId);
        headers.put("foreignSource", foreignSource);
        headers.put("deviceA", deviceAForeignId);
        headers.put("deviceZ", deviceZForeignId);
        headers.put("nodeForeignSource", nodeForeignSource);
        headers.put("serviceName", serviceName);
        return (NCSServicePath)this.m_template.requestBodyAndHeaders("direct:start", null, headers, NCSServicePath.class);
    }
}

