/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.browsers;

import com.vaadin.ui.Button;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.ui.Table;
import org.opennms.features.topology.api.browsers.AbstractSelectionLinkGenerator;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.browsers.ToStringColumnGenerator;

public class NodeSelectionLinkGenerator
extends AbstractSelectionLinkGenerator {
    private static final long serialVersionUID = -1072007643387089006L;
    private final String m_nodeIdProperty;
    private final String m_nodeLabelProperty;
    private final Table.ColumnGenerator m_generator;

    public NodeSelectionLinkGenerator(String nodeIdProperty, String nodeLabelProperty) {
        this(nodeIdProperty, nodeLabelProperty, new ToStringColumnGenerator());
    }

    private NodeSelectionLinkGenerator(String nodeIdProperty, String nodeLabelProperty, Table.ColumnGenerator generator) {
        this.m_nodeIdProperty = nodeIdProperty;
        this.m_nodeLabelProperty = nodeLabelProperty;
        this.m_generator = generator;
    }

    public Object generateCell(final Table source, final Object itemId, Object columnId) {
        final Property nodeIdProperty = source.getContainerProperty(itemId, (Object)this.m_nodeIdProperty);
        Object cellValue = this.m_generator.generateCell(source, itemId, columnId);
        if (cellValue == null) {
            return null;
        }
        if (nodeIdProperty.getValue() == null) {
            return cellValue;
        }
        Button button = new Button(cellValue.toString());
        button.setStyleName("link");
        button.setDescription(((Integer)nodeIdProperty.getValue()).toString());
        button.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                Integer nodeId = (Integer)nodeIdProperty.getValue();
                String nodeLabel = (String)source.getContainerProperty(itemId, (Object)NodeSelectionLinkGenerator.this.m_nodeLabelProperty).getValue();
                DefaultVertexRef vertexRef = new DefaultVertexRef("nodes", String.valueOf(nodeId), nodeLabel);
                NodeSelectionLinkGenerator.this.fireVertexUpdatedEvent((VertexRef)vertexRef);
            }
        });
        return button;
    }
}

